/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.utils.StringTools;
import java.util.ListIterator;
import org.sweble.wikitext.engine.nodes.EngNowiki;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.utils.AstTextUtils;
import org.sweble.wikitext.parser.utils.AstTextUtilsImpl;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class EngineAstTextUtilsImpl
extends AstTextUtilsImpl
implements EngineAstTextUtils {
    public EngineAstTextUtilsImpl(ParserConfig parserConfig) {
        super(parserConfig);
    }

    @Override
    public WtNode trim(WtNode n) {
        return this.trimRight(this.trimLeft(n));
    }

    @Override
    public WtNode trimLeft(WtNode n) {
        if (n.isList()) {
            WtNodeList l = (WtNodeList)n;
            ListIterator i = l.listIterator();
            block4: while (i.hasNext()) {
                WtNode item = (WtNode)i.next();
                switch (item.getNodeType()) {
                    case 4097: {
                        WtText t = (WtText)item;
                        String text = t.getContent();
                        if (text.isEmpty()) {
                            i.remove();
                            continue block4;
                        }
                        String trimmed = StringTools.trimLeft((String)text);
                        if (trimmed.equals(text)) break block4;
                        if (trimmed.isEmpty()) {
                            i.remove();
                            continue block4;
                        }
                        t.setContent(trimmed);
                        break block4;
                    }
                    case 196613: 
                    case 458754: {
                        continue block4;
                    }
                }
            }
            return n;
        }
        if (n.getNodeType() == 4097) {
            WtText t = (WtText)n;
            t.setContent(StringTools.trimLeft((String)t.getContent()));
            return n;
        }
        return n;
    }

    @Override
    public WtNode trimRight(WtNode n) {
        if (n.isList()) {
            WtNodeList l = (WtNodeList)n;
            ListIterator i = l.listIterator(l.size());
            block4: while (i.hasPrevious()) {
                WtNode item = (WtNode)i.previous();
                switch (item.getNodeType()) {
                    case 4097: {
                        WtText t = (WtText)item;
                        String text = t.getContent();
                        if (text.isEmpty()) {
                            i.remove();
                            continue block4;
                        }
                        String trimmed = StringTools.trimRight((String)text);
                        if (trimmed.equals(text)) break block4;
                        if (trimmed.isEmpty()) {
                            i.remove();
                            continue block4;
                        }
                        t.setContent(trimmed);
                        break block4;
                    }
                    case 196613: 
                    case 458754: {
                        continue block4;
                    }
                }
            }
            return n;
        }
        if (n.getNodeType() == 4097) {
            WtText t = (WtText)n;
            t.setContent(StringTools.trimRight((String)t.getContent()));
            return n;
        }
        return n;
    }

    public String astToText(WtNode node) throws StringConversionException {
        return super.astToText(node, (AstTextUtilsImpl.SimpleStringConverter)new SimpleEngineStringConverter());
    }

    public String astToText(WtNode node, int ... options) throws StringConversionException {
        return super.astToText(node, (AstTextUtilsImpl.SimpleStringConverter)new SimpleEngineStringConverter(options));
    }

    public AstTextUtils.PartialConversion astToTextPartial(WtNode node) {
        return super.astToTextPartial(node, (AstTextUtilsImpl.PartialStringConverter)new PartialEngineStringConverter());
    }

    public AstTextUtils.PartialConversion astToTextPartial(WtNode node, int ... options) {
        return super.astToTextPartial(node, (AstTextUtilsImpl.PartialStringConverter)new PartialEngineStringConverter(options));
    }

    public class PartialEngineStringConverter
    extends AstTextUtilsImpl.PartialStringConverter {
        protected boolean doNotConvertNowiki;

        public PartialEngineStringConverter() {
            super((AstTextUtilsImpl)EngineAstTextUtilsImpl.this);
            this.doNotConvertNowiki = false;
        }

        public PartialEngineStringConverter(int[] options) {
            this();
            for (int option : options) {
                this.setOption(option);
            }
        }

        protected void setOption(int option) {
            switch (option) {
                case 2: {
                    this.doNotConvertNowiki = true;
                    break;
                }
                default: {
                    super.setOption(option);
                }
            }
        }

        public void dispatch(WtNode node, int nodeType) throws StringConversionException {
            if (!this.doNotConvertNowiki && nodeType == 0x130003) {
                this.visit((EngNowiki)node);
            } else {
                super.dispatch(node, nodeType);
            }
        }

        protected void visit(EngNowiki node) {
            this.b.append(node.getContent());
        }
    }

    public static class SimpleEngineStringConverter
    extends AstTextUtilsImpl.SimpleStringConverter {
        protected boolean doNotConvertNowiki = false;

        public SimpleEngineStringConverter() {
        }

        public SimpleEngineStringConverter(int[] options) {
            this();
            for (int option : options) {
                this.setOption(option);
            }
        }

        protected void setOption(int option) {
            switch (option) {
                case 2: {
                    this.doNotConvertNowiki = true;
                    break;
                }
                default: {
                    super.setOption(option);
                }
            }
        }

        public void dispatch(WtNode node, int nodeType) throws StringConversionException {
            if (!this.doNotConvertNowiki && nodeType == 0x130003) {
                this.visit((EngNowiki)node);
            } else {
                super.dispatch(node, nodeType);
            }
        }

        protected void visit(EngNowiki node) {
            this.b.append(node.getContent());
        }
    }
}

