/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class StringToDateTimeConverter {
    private ArrayList<DateTimeMatcher> matchers = new ArrayList();
    private final Calendar calendar;

    public StringToDateTimeConverter() {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        this.calendar.set(16, 0);
        this.initDefault();
    }

    public StringToDateTimeConverter(Calendar cal) {
        this.calendar = cal;
        this.initDefault();
    }

    private void initDefault() {
        this.matchers.add(new NowMatcher());
        this.matchers.add(new TomorrowMatcher());
        this.matchers.add(new DaysMatcher());
        this.matchers.add(new UnixTimestampMatcher());
        this.matchers.add(new DateFormatMatcher("dd.MM.yyyy"));
        this.matchers.add(new DateFormatMatcher("d MMM yyyy"));
        this.matchers.add(new DateFormatMatcher("yyyy.MM.dd G 'at' HH:mm:ss z"));
        this.matchers.add(new DateFormatMatcher("EEE, d MMM yyyy HH:mm:ss Z"));
        this.matchers.add(new DateFormatMatcher("yyyy MM dd"));
        this.matchers.add(new DateFormatMatcher("yyyy-MM-dd"));
    }

    public void registerDateTimeMatcher(DateTimeMatcher matcher) {
        this.matchers.add(matcher);
    }

    public Date convertString(String input) {
        for (DateTimeMatcher matcher : this.matchers) {
            Date date = matcher.tryConvert(input);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    private class UnixTimestampMatcher
    implements DateTimeMatcher {
        private final Pattern unixTimestamp = Pattern.compile("@?\\d{10}");

        private UnixTimestampMatcher() {
        }

        @Override
        public Date tryConvert(String input) {
            if (this.unixTimestamp.matcher(input).matches()) {
                try {
                    long timestamp = Long.parseUnsignedLong(input.substring(1));
                    StringToDateTimeConverter.this.calendar.setTimeInMillis(timestamp * 1000L);
                    return StringToDateTimeConverter.this.calendar.getTime();
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
    }

    private class DaysMatcher
    implements DateTimeMatcher {
        private final Pattern days = Pattern.compile("[\\-\\+]?\\d+ days");

        private DaysMatcher() {
        }

        @Override
        public Date tryConvert(String input) {
            if (this.days.matcher(input).matches()) {
                try {
                    int day = Integer.parseInt(input.split(" ")[0]);
                    StringToDateTimeConverter.this.calendar.setTime(new Date());
                    StringToDateTimeConverter.this.calendar.add(6, day);
                    return StringToDateTimeConverter.this.calendar.getTime();
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
    }

    private class TomorrowMatcher
    implements DateTimeMatcher {
        private final Pattern tomorrow = Pattern.compile("tomorrow");

        private TomorrowMatcher() {
        }

        @Override
        public Date tryConvert(String input) {
            if (this.tomorrow.matcher(input).matches()) {
                StringToDateTimeConverter.this.calendar.setTime(new Date());
                StringToDateTimeConverter.this.calendar.add(6, 1);
                return StringToDateTimeConverter.this.calendar.getTime();
            }
            return null;
        }
    }

    private class NowMatcher
    implements DateTimeMatcher {
        private final Pattern now = Pattern.compile("now");

        private NowMatcher() {
        }

        @Override
        public Date tryConvert(String input) {
            if (this.now.matcher(input).matches()) {
                return new Date();
            }
            return null;
        }
    }

    private class DateFormatMatcher
    implements DateTimeMatcher {
        private final DateFormat dateFormat;

        public DateFormatMatcher(String dateString) {
            this.dateFormat = new SimpleDateFormat(dateString);
            this.dateFormat.setCalendar(StringToDateTimeConverter.this.calendar);
        }

        @Override
        public Date tryConvert(String input) {
            try {
                return this.dateFormat.parse(input);
            }
            catch (ParseException ex) {
                return null;
            }
        }
    }

    public static interface DateTimeMatcher {
        public Date tryConvert(String var1);
    }
}

