/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.utils.WrappedException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public enum UrlEncoding {
    QUERY{

        @Override
        public String encode(String text) {
            try {
                return URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    }
    ,
    WIKI{

        @Override
        public String encode(String text) {
            text = text.replace(' ', '_');
            try {
                text = URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedException((Throwable)e);
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch == '%') {
                    char ch1 = text.charAt(++i);
                    char ch2 = text.charAt(++i);
                    int code = this.hexToDec(ch1) * 16 + this.hexToDec(ch2);
                    switch (code) {
                        case 33: 
                        case 36: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 44: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 64: {
                            b.append((char)code);
                            break;
                        }
                        default: {
                            b.append(ch);
                            b.append(ch1);
                            b.append(ch2);
                            break;
                        }
                    }
                    continue;
                }
                b.append(ch);
            }
            return b.toString();
        }

        private int hexToDec(char ch) {
            if (ch >= 'A' && ch <= 'F') {
                return ch - 65 + 10;
            }
            if (ch >= 'a' && ch <= 'f') {
                return ch - 97 + 10;
            }
            if (ch >= '0' && ch <= '9') {
                return ch - 48 + 0;
            }
            throw new IllegalArgumentException("Not a valid hex digit!");
        }
    }
    ,
    PATH{

        @Override
        public String encode(String text) {
            try {
                return URLEncoder.encode(text, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    };


    public abstract String encode(String var1);
}

