/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.utils.UrlEncoding;
import org.sweble.wikitext.engine.utils.UrlType;

public class UrlService {
    public URL convertUrl(UrlType full, URL titleUrl) {
        return titleUrl;
    }

    public static URL makeUrlToArticle(String parametrizedUrl, PageTitle title) throws MalformedURLException {
        String encodedTitle = UrlEncoding.WIKI.encode(title.getNormalizedFullTitle());
        return new URL(parametrizedUrl.replace("$1", encodedTitle));
    }

    public static URL appendQuery(URL url, String urlEncodedQuery) throws MalformedURLException {
        String ef = url.toExternalForm();
        return ef.indexOf(63) != -1 ? new URL(ef + "&" + urlEncodedQuery) : new URL(ef + "?" + urlEncodedQuery);
    }

    public static URL appendQuery(URL url, Map<String, String> query) throws MalformedURLException {
        return UrlService.appendQuery(url, UrlService.queryMapToString(query));
    }

    public static String queryMapToString(Map<String, String> query) {
        StringBuilder b = new StringBuilder();
        UrlEncoding encoder = UrlEncoding.QUERY;
        boolean first = true;
        for (Map.Entry<String, String> e : query.entrySet()) {
            if (!first) {
                b.append('&');
            }
            b.append(encoder.encode(e.getKey()));
            b.append('&');
            b.append(encoder.encode(e.getValue()));
            first = false;
        }
        return b.toString();
    }
}

