/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy;

import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.ParserCommon;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.io.IOException;
import java.io.StringReader;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;
import org.sweble.wikitext.lazy.parser.LazyRatsParser;
import org.sweble.wikitext.lazy.preprocessor.PreprocessedWikitext;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public class LazyParser
extends ParserCommon {
    private final ParserConfigInterface config;
    private LazyRatsParser parser;

    public LazyParser(ParserConfigInterface config) {
        this.config = config;
    }

    public AstNode parseArticle(String src, String title) throws IOException, ParseException {
        PreprocessedWikitext ppWt = new PreprocessedWikitext(src, new EntityMap());
        return this.parseArticle(ppWt, title);
    }

    public AstNode parseArticle(PreprocessedWikitext wikitext, String title) throws IOException, ParseException {
        StringReader in = new StringReader(wikitext.getWikitext());
        int inputSize = wikitext.getWikitext().getBytes().length;
        this.parser = new LazyRatsParser(in, title, inputSize);
        this.parser.getState().init(this.config, wikitext.getEntityMap());
        Result r = null;
        r = this.parser.pArticle(0);
        if (LazyRatsParser.isStatsEnabled()) {
            LazyRatsParser.getStats().dump(System.err);
        }
        if (r.hasValue()) {
            SemanticValue v = (SemanticValue)r;
            if (v.value instanceof LazyParsedPage) {
                return this.process((AstNode)((LazyParsedPage)((Object)v.value)));
            }
            throw new ParseException("Internal parser error: Unexpected parser result type!");
        }
        ParseError err = (ParseError)r;
        if (err.index == -1) {
            throw new ParseException("Parse error: No information available");
        }
        throw new ParseException(String.format("%s: %s", this.parser.location(err.index), err.msg));
    }
}

