/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy;

import de.fau.cs.osr.ptk.common.ParserCommon;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.io.IOException;
import java.io.StringReader;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.preprocessor.LazyPreprocessedPage;
import org.sweble.wikitext.lazy.preprocessor.LazyRatsPreprocessor;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public class LazyPreprocessor
extends ParserCommon {
    private LazyRatsPreprocessor preprocessor = null;
    private final ParserConfigInterface config;

    public LazyPreprocessor(ParserConfigInterface config) {
        this.config = config;
    }

    public AstNode parseArticle(String src, String title) throws IOException, ParseException {
        return this.parseArticle(src, title, false);
    }

    public AstNode parseArticle(String src, String title, boolean forInclusion) throws IOException, ParseException {
        StringReader in = new StringReader(src);
        int inputSize = src.getBytes().length;
        this.preprocessor = new LazyRatsPreprocessor(in, title, inputSize);
        this.preprocessor.getState().init(this.config, forInclusion);
        Result r = this.preprocessor.pArticle(0);
        if (r.hasValue()) {
            SemanticValue v = (SemanticValue)r;
            if (v.value instanceof LazyPreprocessedPage) {
                return this.process((AstNode)((LazyPreprocessedPage)((Object)v.value)));
            }
            throw new ParseException("Internal preprocessor error: Unexpected preprocessor result type!");
        }
        ParseError err = (ParseError)r;
        if (err.index == -1) {
            throw new ParseException("Parse error: No information available");
        }
        throw new ParseException(String.format("%s: %s", this.preprocessor.location(err.index), err.msg));
    }
}

