/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.utils.StringUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.sweble.wikitext.lazy.parser.LazyRatsParser;

public class ParserStats {
    private final Map<String, MemoizedProduction> memoizedProductions = new HashMap<String, MemoizedProduction>();

    public Map<String, MemoizedProduction> getMemoizedProductions() {
        return this.memoizedProductions;
    }

    public void parsed(String prod) {
        ++this.getMemoizedProduction((String)prod).parsed;
    }

    public void failed(String prod) {
        ++this.getMemoizedProduction((String)prod).failed;
    }

    public void called(String prod) {
        ++this.getMemoizedProduction((String)prod).called;
    }

    public void reused(String prod) {
        ++this.getMemoizedProduction((String)prod).reused;
    }

    private MemoizedProduction getMemoizedProduction(String prod) {
        MemoizedProduction p = this.memoizedProductions.get(prod);
        if (p == null) {
            p = new MemoizedProduction();
            this.memoizedProductions.put(prod, p);
        }
        return p;
    }

    public void dump(PrintStream err) {
        for (Map.Entry<String, MemoizedProduction> x : LazyRatsParser.getStats().getMemoizedProductions().entrySet()) {
            err.print(x.getKey() + ":");
            err.print(StringUtils.strrep((char)' ', (int)(20 - x.getKey().length())));
            err.println(x.getValue());
        }
    }

    public static final class MemoizedProduction {
        public int called;
        public int failed;
        public int reused;
        public int parsed;

        public String toString() {
            return String.format("MemoizedProduction [called=%5d, reused=%5d, parsed=%5d, failed=%5d]", this.called, this.reused, this.parsed, this.failed);
        }
    }
}

