/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.Tuple;
import de.fau.cs.osr.utils.Tuple2;
import java.util.Iterator;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.preprocessor.Ignored;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;
import org.sweble.wikitext.lazy.utils.XmlCharRef;
import org.sweble.wikitext.lazy.utils.XmlEntityRef;

public class StringConverterPartial {
    public static Tuple2<String, NodeList> convert(AstNode astNode) {
        return StringConverterPartial.convert(astNode, null, 0);
    }

    public static Tuple2<String, NodeList> convert(AstNode astNode, ParserConfigInterface resolver, int options) {
        ConverterVisitor converter = new ConverterVisitor(options, resolver);
        return (Tuple2)converter.go(astNode);
    }

    protected static final class ConverterVisitor
    extends AstVisitor {
        private final StringBuilder result = new StringBuilder();
        private final ParserConfigInterface entityResolver;
        private final int options;
        private AstNode failedOnNode = null;

        public ConverterVisitor(int options, ParserConfigInterface resolver) {
            this.entityResolver = resolver;
            this.options = options;
            if (resolver != null && !this.opt(2)) {
                throw new IllegalArgumentException("If a resolver instance is given the option RESOLVE_ENTITY_REF is required");
            }
            if (resolver == null && this.opt(2)) {
                throw new IllegalArgumentException("If the option RESOLVE_ENTITY_REF is given a resolver instance is required");
            }
        }

        protected Object after(AstNode node, Object result) {
            NodeList tail = null;
            if (this.failedOnNode != null) {
                tail = this.failedOnNode.isNodeType(2) ? (NodeList)this.failedOnNode : new NodeList(this.failedOnNode);
            }
            return Tuple.from((Object)this.result.toString(), tail);
        }

        public Object visitNotFound(AstNode node) {
            this.failedOnNode = node;
            return node;
        }

        public void visit(NodeList n) {
            Iterator i = n.iterator();
            while (i.hasNext()) {
                AstNode c = (AstNode)i.next();
                this.dispatch(c);
                if (this.failedOnNode == null) continue;
                this.failedOnNode = new NodeList();
                this.failedOnNode.add(c);
                while (i.hasNext()) {
                    this.failedOnNode.add((AstNode)i.next());
                }
                break block0;
            }
        }

        public void visit(XmlCharRef n) {
            if (this.opt(1)) {
                this.result.append(Character.toChars(n.getCodePoint()));
            } else if (this.opt(4)) {
                this.failedOnNode = n;
            } else {
                this.result.append("&#");
                this.result.append(n.getCodePoint());
                this.result.append(';');
            }
        }

        public void visit(XmlEntityRef n) {
            String replacement = null;
            if (this.opt(2)) {
                replacement = this.entityResolver.resolveXmlEntity(n.getName());
            }
            if (replacement == null) {
                if (this.opt(4)) {
                    this.failedOnNode = n;
                } else {
                    this.result.append('&');
                    this.result.append(n.getName());
                    this.result.append(';');
                }
            } else {
                this.result.append(replacement);
            }
        }

        public void visit(Text n) {
            this.result.append(n.getContent());
        }

        public void visit(XmlComment n) {
            if (this.opt(8)) {
                this.failedOnNode = n;
            }
        }

        public void visit(Ignored n) {
            if (this.opt(16)) {
                this.failedOnNode = n;
            }
        }

        private boolean opt(int x) {
            return (this.options & x) == x;
        }
    }
}

