/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.ParserState;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.util.regex.Pattern;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.LazyParserContext;
import org.sweble.wikitext.lazy.parser.LinkBuilder;
import org.sweble.wikitext.lazy.parser.ParserAtoms;
import org.sweble.wikitext.lazy.parser.ParserScopes;

public class LazyParserState
extends ParserState<LazyParserContext> {
    private EntityMap entityMap = new EntityMap();
    private ParserConfigInterface config;
    private Pattern postfixPattern;
    private Pattern prefixPattern;
    private boolean autoCorrect;
    private boolean warningsEnabled;
    private boolean gatherRtData;

    protected LazyParserContext instantiateContext() {
        return new LazyParserContext();
    }

    public EntityMap getEntityMap() {
        return this.entityMap;
    }

    public AstNode getEntity(int id) {
        return this.entityMap.getEntity(id);
    }

    public ParserConfigInterface getConfig() {
        return this.config;
    }

    public void init(ParserConfigInterface config, EntityMap entityMap) {
        this.config = config;
        this.entityMap = entityMap;
        this.autoCorrect = config.isAutoCorrect();
        this.warningsEnabled = config.isWarningsEnabled();
        this.gatherRtData = config.isGatherRtData();
        this.prefixPattern = Pattern.compile("(" + config.getInternalLinkPrefixPattern() + ")$");
        this.postfixPattern = Pattern.compile(config.getInternalLinkPostfixPattern());
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public boolean isWarnignsEnabled() {
        return this.warningsEnabled;
    }

    public boolean isGatherRtData() {
        return this.gatherRtData;
    }

    public Pattern getInternalLinkPrefixPattern() {
        return this.prefixPattern;
    }

    public Pattern getInternalLinkPostfixPattern() {
        return this.postfixPattern;
    }

    public LinkBuilder getLinkBuilder() {
        return ((LazyParserContext)this.getTop()).getLinkBuilder();
    }

    public void initLinkBuilder(String target) {
        ((LazyParserContext)this.getTop()).initLinkBuilder(this.config, target);
    }

    public ParserScopes getScope() {
        return ((LazyParserContext)this.getTop()).getScope();
    }

    public void setScope(ParserScopes scope) {
        LazyParserContext c = (LazyParserContext)this.getTop();
        c.setScope(scope);
        if (scope.isSticky()) {
            c.addStickingScope(scope);
        }
    }

    public boolean accepts(ParserAtoms atom) {
        LazyParserContext c = (LazyParserContext)this.getTop();
        if (c.getScope().accepts(atom)) {
            int i = 0;
            for (int sticking = c.getStickingScopes(); sticking != 0; sticking >>= 1) {
                if ((sticking & 1) != 0 && !ParserScopes.values()[i].accepts(atom)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean inScope(ParserScopes scope) {
        LazyParserContext c = (LazyParserContext)this.getTop();
        if (c.getScope() == scope) {
            return true;
        }
        int bit = 1 << scope.ordinal();
        return 0 != (c.getStickingScopes() & bit);
    }
}

