/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.util.ArrayList;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.ImageHorizAlign;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.ImageVertAlign;
import org.sweble.wikitext.lazy.parser.ImageViewFormat;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.LinkOptionAltText;
import org.sweble.wikitext.lazy.parser.LinkTarget;
import org.sweble.wikitext.lazy.parser.LinkTitle;
import org.sweble.wikitext.lazy.parser.Url;

public class LinkBuilder {
    private String target;
    private String linkPage;
    private Url linkUrl;
    private LinkOptionAltText alt;
    private LinkTitle title;
    private int width;
    private int height;
    private boolean upright;
    private ImageHorizAlign hAlign;
    private ImageVertAlign vAlign;
    private ImageViewFormat format;
    private boolean border;
    private ArrayList<Warning> warnings;
    private ParserConfigInterface.TargetType targetType;

    public LinkBuilder(ParserConfigInterface parserConfig, String target) {
        this.target = target;
        this.targetType = parserConfig.classifyTarget(target);
        this.title = null;
        this.width = -1;
        this.height = -1;
        this.upright = false;
        this.hAlign = null;
        this.vAlign = null;
        this.format = null;
        this.border = false;
        this.linkUrl = null;
        this.linkPage = null;
        this.alt = null;
    }

    public boolean isImageTarget() {
        return this.targetType == ParserConfigInterface.TargetType.IMAGE;
    }

    public boolean isValidTarget() {
        return this.targetType != ParserConfigInterface.TargetType.INVALID;
    }

    public boolean addKeyword(String keyword) {
        ImageViewFormat f = ImageViewFormat.which(keyword);
        if (f != null) {
            this.format = this.format == null ? f : this.format.combine(f);
            return true;
        }
        ImageHorizAlign h = ImageHorizAlign.which(keyword);
        if (h != null) {
            this.hAlign = h;
            return true;
        }
        ImageVertAlign v = ImageVertAlign.which(keyword);
        if (v != null) {
            this.vAlign = v;
            return true;
        }
        if (keyword.equals("border")) {
            this.border = true;
            return true;
        }
        if (keyword.equals("upright")) {
            this.upright = true;
            return true;
        }
        return false;
    }

    public void setHeight(int height) {
        if (height >= 0) {
            this.height = height;
        }
    }

    public void setWidth(int width) {
        if (width >= 0) {
            this.width = width;
        }
    }

    public void setLink(AstNode target) {
        if (target.isNodeType(720900)) {
            this.linkPage = null;
            this.linkUrl = (Url)target;
        } else {
            if (this.linkUrl != null) {
                return;
            }
            this.linkPage = ((LinkTarget)target).getContent();
        }
    }

    public void setAlt(LinkOptionAltText alt) {
        this.alt = alt;
    }

    public void setTitle(LinkTitle title) {
        this.title = title;
    }

    public AstNode build(NodeList options, String postfix) {
        if (this.title == null) {
            this.title = new LinkTitle();
        }
        if (this.targetType == ParserConfigInterface.TargetType.IMAGE) {
            if (this.hAlign == null) {
                this.hAlign = ImageHorizAlign.NONE;
            }
            if (this.vAlign == null) {
                this.vAlign = ImageVertAlign.MIDDLE;
            }
            if (this.format == null) {
                this.format = ImageViewFormat.UNRESTRAINED;
            }
            if (this.alt == null) {
                this.alt = new LinkOptionAltText();
            }
            ImageLink result = new ImageLink(this.target, options, this.title, this.format, this.border, this.hAlign, this.vAlign, this.width, this.height, this.upright, this.linkPage, this.linkUrl, this.alt);
            this.finish((AstNode)result);
            return result;
        }
        InternalLink result = new InternalLink("", this.target, this.title, postfix);
        this.finish((AstNode)result);
        return result;
    }

    public void addWarning(Warning warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        this.warnings.add(warning);
    }

    public void finish(AstNode n) {
        if (this.warnings != null && !this.warnings.isEmpty()) {
            n.setAttribute("warnings", this.warnings);
        }
    }
}

