/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import org.sweble.wikitext.lazy.preprocessor.Ignored;
import org.sweble.wikitext.lazy.preprocessor.LazyPreprocessedPage;
import org.sweble.wikitext.lazy.preprocessor.OnlyInclude;
import org.sweble.wikitext.lazy.preprocessor.PreprocessedWikitext;
import org.sweble.wikitext.lazy.preprocessor.ProtectedText;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;

public class PreprocessorToParserTransformer {
    public static PreprocessedWikitext transform(LazyPreprocessedPage preprocessedArticle, EntityMap entityMap) {
        return new PreprocessedWikitext((String)new TransformVisitor(entityMap, false).go((Object)preprocessedArticle), entityMap);
    }

    public static PreprocessedWikitext transform(LazyPreprocessedPage preprocessedArticle) {
        EntityMap entityMap = preprocessedArticle.getEntityMap();
        return new PreprocessedWikitext((String)new TransformVisitor(entityMap, false).go((Object)preprocessedArticle), entityMap);
    }

    public static PreprocessedWikitext transform(LazyPreprocessedPage preprocessedArticle, EntityMap entityMap, boolean trim) {
        return new PreprocessedWikitext((String)new TransformVisitor(entityMap, trim).go((Object)preprocessedArticle), entityMap);
    }

    public static PreprocessedWikitext transform(LazyPreprocessedPage preprocessedArticle, boolean trim) {
        EntityMap entityMap = preprocessedArticle.getEntityMap();
        return new PreprocessedWikitext((String)new TransformVisitor(entityMap, trim).go((Object)preprocessedArticle), entityMap);
    }

    protected static final class TransformVisitor
    extends AstVisitor {
        private StringBuilder builder;
        private EntityMap entityMap;
        private final boolean trim;

        public TransformVisitor(EntityMap entityMap, boolean trim) {
            this.entityMap = entityMap;
            this.trim = trim;
        }

        protected boolean before(AstNode node) {
            this.builder = new StringBuilder();
            return super.before((Object)node);
        }

        protected String after(AstNode node, Object result) {
            return this.builder.toString();
        }

        public void visit(LazyPreprocessedPage n) {
            this.iterate((AstNode)n);
        }

        public void visit(AstNode n) {
            this.makeParserEntity(n);
        }

        public void visit(ProtectedText n) {
            this.makeParserEntity((AstNode)n);
        }

        private void makeParserEntity(AstNode n) {
            int id = this.entityMap.registerEntity(n);
            this.builder.append('\ue000');
            this.builder.append(id);
            this.builder.append('\ue001');
        }

        public void visit(NodeList n) {
            this.iterate((AstNode)n);
        }

        public void visit(OnlyInclude n) {
            this.iterate((AstNode)n);
        }

        public void visit(Text n) {
            this.builder.append(n.getContent());
        }

        public void visit(Ignored n) {
        }

        public void visit(XmlComment n) {
            if (!this.trim) {
                this.visit((AstNode)n);
            }
        }
    }
}

