/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.Location;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;

public class AstCompressor
extends AstVisitor {
    public static AstNode process(AstNode a) {
        return (AstNode)new AstCompressor().go(a);
    }

    public static LazyParsedPage process(LazyParsedPage a) {
        return (LazyParsedPage)((Object)new AstCompressor().go((Object)a));
    }

    protected Object after(AstNode node, Object result) {
        return node;
    }

    public void visit(AstNode n) {
        this.iterate(n);
    }

    public void visit(NodeList n) {
        ListIterator i = n.listIterator();
        while (i.hasNext()) {
            AstNode current = (AstNode)i.next();
            if (current.getNodeType() == 4097) {
                if (!i.hasNext()) continue;
                AstNode next = (AstNode)i.next();
                if (next.getNodeType() == 4097) {
                    i.previous();
                    i.previous();
                    this.compress(i, current.getNativeLocation());
                    continue;
                }
                this.dispatch(current);
                this.dispatch(next);
                continue;
            }
            this.dispatch(current);
        }
    }

    private void compress(ListIterator<AstNode> i, Location location) {
        String ct = "";
        HashMap ca = null;
        while (i.hasNext()) {
            AstNode n = i.next();
            if (n.getNodeType() != 4097) {
                i.previous();
                break;
            }
            Text t = (Text)n;
            ct = ct + t.getContent();
            Map attrs = t.getAttributes();
            if (!attrs.isEmpty()) {
                if (ca == null) {
                    ca = new HashMap(attrs);
                } else {
                    this.mergeAttributes(ca, attrs);
                }
            }
            i.remove();
        }
        Text text = new Text(ct);
        if (ca != null) {
            text.setAttributes(ca);
        }
        if (location != null) {
            text.setNativeLocation(location);
        }
        i.add((AstNode)text);
    }

    private void mergeAttributes(HashMap<String, Object> ca, Map<String, Object> attrs) {
        for (Map.Entry<String, Object> attr : attrs.entrySet()) {
            Object old = ca.put(attr.getKey(), attr.getValue());
            if (old == null) continue;
            if (attr.getKey() == "warnings") {
                List w0 = (List)old;
                List w1 = (List)attr.getValue();
                ArrayList wNew = new ArrayList(w0.size() + w1.size());
                wNew.addAll(w0);
                wNew.addAll(w1);
                ca.put(attr.getKey(), wNew);
                continue;
            }
            throw new UnsupportedOperationException("Merging of text nodes would overwrite attributes!");
        }
    }
}

