/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.LinkTargetParser;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.WarningSeverity;
import org.sweble.wikitext.lazy.postprocessor.ScopeType;

public class SimpleParserConfig
implements ParserConfigInterface {
    private static final HashSet<String> allowed = new HashSet();
    private static final HashSet<String> emptyOnly;
    private static final HashMap<String, ScopeType> elementTypes;
    private final boolean warningsEnabled;
    private final boolean gatherRtd;
    private final boolean autoCorrect;

    public SimpleParserConfig() {
        this.warningsEnabled = true;
        this.gatherRtd = true;
        this.autoCorrect = false;
    }

    public SimpleParserConfig(boolean warningsEnabled, boolean gatherRtd, boolean autoCorrect) {
        this.warningsEnabled = warningsEnabled;
        this.gatherRtd = gatherRtd;
        this.autoCorrect = autoCorrect;
    }

    @Override
    public boolean isWarningsEnabled() {
        return this.warningsEnabled;
    }

    @Override
    public boolean isGatherRtData() {
        return this.gatherRtd;
    }

    @Override
    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    @Override
    public boolean isWarningLevelEnabled(WarningSeverity severity) {
        return true;
    }

    @Override
    public boolean isValidXmlEntityRef(String name) {
        return true;
    }

    @Override
    public boolean isUrlProtocol(String proto) {
        return "http://".equalsIgnoreCase(proto) || "https://".equalsIgnoreCase(proto) || "mail:".equalsIgnoreCase(proto);
    }

    @Override
    public boolean isMagicWord(String word) {
        return "NOTOC".equalsIgnoreCase(word);
    }

    @Override
    public boolean isRedirectKeyword(String keyword) {
        return keyword.equalsIgnoreCase("#redirect");
    }

    @Override
    public String getInternalLinkPrefixPattern() {
        return "[\u00e4\u00f6\u00fc\u00dfa-z]+";
    }

    @Override
    public String getInternalLinkPostfixPattern() {
        return "[\u00e4\u00f6\u00fc\u00dfa-z]+";
    }

    @Override
    public ParserConfigInterface.TargetType classifyTarget(String target) {
        LinkTargetParser ltp = new LinkTargetParser();
        try {
            ltp.parse(this, target);
        }
        catch (LinkTargetException e) {
            return ParserConfigInterface.TargetType.INVALID;
        }
        String ns = ltp.getNamespace();
        if ("file".equalsIgnoreCase(ns) || "image".equalsIgnoreCase(ns)) {
            return ParserConfigInterface.TargetType.IMAGE;
        }
        return ParserConfigInterface.TargetType.PAGE;
    }

    @Override
    public boolean isNamespace(String name) {
        return "image".equalsIgnoreCase(name) || "file".equalsIgnoreCase(name) || "template".equals(name) || "media".equals(name) || "category".equals(name);
    }

    @Override
    public boolean isInterwikiName(String name) {
        return "mediawiki".equalsIgnoreCase(name);
    }

    @Override
    public boolean isLocalInterwikiName(String name) {
        return false;
    }

    @Override
    public boolean isValidExtensionTagName(String name) {
        return "ref".equalsIgnoreCase(name) || "pre".equalsIgnoreCase(name) || "nowiki".equalsIgnoreCase(name) || "gallery".equalsIgnoreCase(name) || "includeonly".equalsIgnoreCase(name) || "noinclude".equalsIgnoreCase(name) || "onlyinclude".equalsIgnoreCase(name);
    }

    @Override
    public String resolveXmlEntity(String name) {
        if ("amp".equalsIgnoreCase(name)) {
            return "&";
        }
        if ("lt".equalsIgnoreCase(name)) {
            return "<";
        }
        if ("nbsp".equalsIgnoreCase(name)) {
            return "\u00a0";
        }
        return null;
    }

    @Override
    public boolean isXmlElementAllowed(String name) {
        return allowed.contains(name.toLowerCase());
    }

    @Override
    public boolean isXmlElementEmptyOnly(String name) {
        return emptyOnly.contains(name.toLowerCase());
    }

    @Override
    public ScopeType getXmlElementType(String name) {
        ScopeType type = elementTypes.get(name);
        if (type == null) {
            return ScopeType.XML_BLOCK;
        }
        return type;
    }

    static {
        allowed.addAll(Arrays.asList("abbr", "b", "big", "blockquote", "br", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"));
        emptyOnly = new HashSet();
        emptyOnly.addAll(Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"));
        elementTypes = new HashMap();
        elementTypes.put("p", ScopeType.XML_PARAGRAPH);
        for (String e : Arrays.asList("abbr", "b", "big", "br", "cite", "code", "em", "font", "i", "s", "small", "span", "strike", "strong", "sub", "sup", "tt", "u", "var")) {
            elementTypes.put(e, ScopeType.XML_INLINE);
        }
        for (String e : Arrays.asList("blockquote", "center", "del", "div", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "ol", "pre", "ul")) {
            elementTypes.put(e, ScopeType.XML_BLOCK);
        }
        for (String e : Arrays.asList("dd", "dl", "dt", "li")) {
            elementTypes.put(e, ScopeType.XML_ITEM);
        }
        for (String e : Arrays.asList("caption", "td", "tr", "th")) {
            elementTypes.put(e, ScopeType.XML_TABLE_ITEM);
        }
        for (String e : Arrays.asList("table")) {
            elementTypes.put(e, ScopeType.XML_TABLE);
        }
    }
}

