/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalBorders;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnHeaderRendererAddon
extends AbstractComponentAddon {
    private static final Logger LOG = Logger.getLogger(ColumnHeaderRendererAddon.class.getName());

    public ColumnHeaderRendererAddon() {
        super("ColumnHeaderRenderer");
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addBasicDefaults(addon, defaults);
        defaults.addAll(Arrays.asList("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-up.png"), "ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-dn.png")));
        this.hackMetalBorder(addon, defaults);
    }

    private void hackMetalBorder(LookAndFeelAddons addon, List<Object> defaults) {
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        if (border instanceof MetalBorders.TableHeaderBorder) {
            border = new BorderUIResource.CompoundBorderUIResource(border, BorderFactory.createEmptyBorder());
            defaults.add("ColumnHeaderRenderer.metalBorderHack");
            defaults.add(border);
        }
    }

    @Override
    protected void addLinuxDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addLinuxDefaults(addon, defaults);
        if (this.isSynth()) {
            defaults.addAll(Arrays.asList("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-up.png"), "ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-dn.png")));
        }
    }

    @Override
    protected void addMacDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addMacDefaults(addon, defaults);
        defaults.addAll(Arrays.asList("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-up.png"), "ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-dn.png")));
    }

    @Override
    protected void addWindowsDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addWindowsDefaults(addon, defaults);
        if (OS.isWindowsXP()) {
            defaults.addAll(Arrays.asList("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-up.png"), "ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-dn.png")));
        } else {
            defaults.addAll(Arrays.asList("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-up.png"), "ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-dn.png")));
        }
        this.hackVistaHeaderBorder(addon, defaults);
    }

    private void hackVistaHeaderBorder(LookAndFeelAddons addon, List<Object> defaults) {
        if (!OS.isWindowsVista() || addon instanceof WindowsClassicLookAndFeelAddons) {
            return;
        }
        defaults.addAll(Arrays.asList("ColumnHeaderRenderer.vistaBorderHack", new BorderUIResource.EmptyBorderUIResource(5, 5, 5, 5)));
    }
}

