/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.util.Contract;

public class AutoCompleteDocument
implements StyledDocument {
    boolean selecting = false;
    boolean strictMatching;
    AbstractAutoCompleteAdaptor adaptor;
    ObjectToStringConverter stringConverter;
    private Document delegate;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter, Document delegate) {
        this.adaptor = Contract.asNotNull(adaptor, "adaptor cannot be null");
        this.strictMatching = strictMatching;
        this.stringConverter = stringConverter == null ? ObjectToStringConverter.DEFAULT_IMPLEMENTATION : stringConverter;
        this.delegate = delegate == null ? new PlainDocument() : delegate;
        Object selected = adaptor.getSelectedItem();
        if (selected != null) {
            this.setText(stringConverter.getPreferredStringForItem(selected));
        }
        adaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter) {
        this(adaptor, strictMatching, stringConverter, null);
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching) {
        this(adaptor, strictMatching, null);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        this.delegate.remove(offs, len);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(offs);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        this.delegate.insertString(offs, str, a);
        LookupResult lookupResult = this.lookupItem(this.getText(0, this.getLength()));
        if (lookupResult.matchingItem != null) {
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else if (this.strictMatching) {
            lookupResult.matchingItem = this.adaptor.getSelectedItem();
            lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            lookupResult.matchingItem = this.getText(0, this.getLength());
            lookupResult.matchingString = this.getText(0, this.getLength());
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(offs + str.length());
    }

    private void setText(String text) {
        try {
            this.delegate.remove(0, this.getLength());
            this.delegate.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void setSelectedItem(Object item, String itemAsString) {
        this.selecting = true;
        this.adaptor.setSelectedItem(item);
        this.adaptor.setSelectedItemAsString(itemAsString);
        this.selecting = false;
    }

    private LookupResult lookupItem(String pattern) {
        int j;
        String[] possibleStrings;
        Object currentItem;
        int i;
        Object selectedItem = this.adaptor.getSelectedItem();
        int n = this.adaptor.getItemCount();
        for (i = 0; i < n; ++i) {
            currentItem = this.adaptor.getItem(i);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j = 0; j < possibleStrings.length; ++j) {
                if (!possibleStrings[j].equalsIgnoreCase(pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j]);
            }
        }
        possibleStrings = this.stringConverter.getPossibleStringsForItem(selectedItem);
        if (possibleStrings != null) {
            for (i = 0; i < possibleStrings.length; ++i) {
                if (!this.startsWithIgnoreCase(possibleStrings[i], pattern)) continue;
                return new LookupResult(selectedItem, possibleStrings[i]);
            }
        }
        n = this.adaptor.getItemCount();
        for (i = 0; i < n; ++i) {
            currentItem = this.adaptor.getItem(i);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j = 0; j < possibleStrings.length; ++j) {
                if (!this.startsWithIgnoreCase(possibleStrings[j], pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j]);
            }
        }
        return new LookupResult(null, "");
    }

    private boolean startsWithIgnoreCase(String base, String prefix) {
        if (base.length() < prefix.length()) {
            return false;
        }
        return base.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public Style addStyle(String nm, Style parent) {
        return ((StyledDocument)this.delegate).addStyle(nm, parent);
    }

    public Color getBackground(AttributeSet attr) {
        return ((StyledDocument)this.delegate).getBackground(attr);
    }

    public Element getCharacterElement(int pos) {
        return ((StyledDocument)this.delegate).getCharacterElement(pos);
    }

    public Font getFont(AttributeSet attr) {
        return ((StyledDocument)this.delegate).getFont(attr);
    }

    public Color getForeground(AttributeSet attr) {
        return ((StyledDocument)this.delegate).getForeground(attr);
    }

    public Style getLogicalStyle(int p) {
        return ((StyledDocument)this.delegate).getLogicalStyle(p);
    }

    public Element getParagraphElement(int pos) {
        return ((StyledDocument)this.delegate).getParagraphElement(pos);
    }

    public Style getStyle(String nm) {
        return ((StyledDocument)this.delegate).getStyle(nm);
    }

    public void removeStyle(String nm) {
        ((StyledDocument)this.delegate).removeStyle(nm);
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        ((StyledDocument)this.delegate).setCharacterAttributes(offset, length, s, replace);
    }

    public void setLogicalStyle(int pos, Style s) {
        ((StyledDocument)this.delegate).setLogicalStyle(pos, s);
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        ((StyledDocument)this.delegate).setParagraphAttributes(offset, length, s, replace);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.delegate.addDocumentListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.delegate.addUndoableEditListener(listener);
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this.delegate.createPosition(offs);
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public Object getProperty(Object key) {
        return this.delegate.getProperty(key);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.delegate.getText(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.delegate.getText(offset, length, txt);
    }

    public void putProperty(Object key, Object value) {
        this.delegate.putProperty(key, value);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.delegate.removeDocumentListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.delegate.removeUndoableEditListener(listener);
    }

    public void render(Runnable r) {
        this.delegate.render(r);
    }

    private static class LookupResult {
        Object matchingItem;
        String matchingString;

        public LookupResult(Object matchingItem, String matchingString) {
            this.matchingItem = matchingItem;
            this.matchingString = matchingString;
        }
    }
}

