/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.test;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializableSupport {
    private SerializableSupport() {
    }

    public static <T> T serialize(T object) {
        try {
            return (T)SerializableSupport.fromBytes(SerializableSupport.toBytes(object));
        }
        catch (ClassNotFoundException shouldNeverHappen) {
            throw new Error(shouldNeverHappen);
        }
        catch (IOException shouldNeverHappen) {
            throw new Error(shouldNeverHappen);
        }
    }

    private static byte[] toBytes(Object object) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectsOut = new ObjectOutputStream(bytesOut);
        objectsOut.writeObject(object);
        return bytesOut.toByteArray();
    }

    private static Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objectsIn = new ObjectInputStream(bytesIn);
        return objectsIn.readObject();
    }

    public static <T> T encode(T object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(baos);
        encoder.writeObject(object);
        encoder.close();
        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(baos.toByteArray()));
        Object copy = decoder.readObject();
        decoder.close();
        return (T)copy;
    }
}

