/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jdesktop.test.PropertyChangeReport;

public final class TestUtils
extends Assert {
    private static final Logger LOG = Logger.getLogger(TestUtils.class.getName());

    private TestUtils() {
    }

    public static void assertContainsType(Object[] objects, Class<?> clazz, int count) {
        if (objects.length == 0 && count == 0) {
            return;
        }
        TestUtils.assertTrue((String)("not enough elements: expected == " + count + " but was == " + objects.length), (count <= objects.length ? 1 : 0) != 0);
        int found = 0;
        for (Object object : objects) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            ++found;
        }
        TestUtils.assertEquals((String)("unexpected number of elements of type " + clazz), (int)count, (int)found);
    }

    public static void assertPropertyChangeEvent(PropertyChangeReport report, Object source, String property, Object oldValue, Object newValue) {
        TestUtils.assertPropertyChangeEvent(report, property, oldValue, newValue);
        TestUtils.assertEquals((String)"event source", (Object)source, (Object)report.getLastSource());
    }

    public static void assertPropertyChangeEvent(PropertyChangeReport report, String property, Object oldValue, Object newValue) {
        if (report.getEventCount() > 1) {
            LOG.info("events: " + report.getEventNames());
        }
        TestUtils.assertEquals((String)"exactly one event", (int)1, (int)report.getEventCount());
        TestUtils.assertEquals((String)"property", (String)property, (String)report.getLastProperty());
        TestUtils.assertEquals((String)"last old value", (Object)oldValue, (Object)report.getLastOldValue());
        TestUtils.assertEquals((String)"last new value", (Object)newValue, (Object)report.getLastNewValue());
    }

    public static void assertPropertyChangeEvent(PropertyChangeReport report, String property, Object oldValue, Object newValue, boolean single) {
        if (report.getEventCount() > 1) {
            LOG.info("events: " + report.getEventNames());
        }
        if (single) {
            TestUtils.assertEquals((String)"exactly one event", (int)1, (int)report.getEventCount());
            TestUtils.assertEquals((String)"property", (String)property, (String)report.getLastProperty());
            TestUtils.assertEquals((String)"last old value", (Object)oldValue, (Object)report.getLastOldValue());
            TestUtils.assertEquals((String)"last new value", (Object)newValue, (Object)report.getLastNewValue());
        } else {
            TestUtils.assertEquals((String)("one event of property " + property), (int)1, (int)report.getEventCount(property));
            TestUtils.assertEquals((String)"old property", (Object)oldValue, (Object)report.getLastOldValue(property));
            TestUtils.assertEquals((String)"new property", (Object)newValue, (Object)report.getLastNewValue(property));
        }
    }

    public static void assertPropertyChangeEvent(PropertyChangeReport report, String property, Object oldValue, Object newValue, boolean single, boolean verifyArrayItems) {
        if (report.getEventCount() > 1) {
            LOG.info("events: " + report.getEventNames());
        }
        if (single) {
            int i;
            List<Object> l2;
            List<Object> l1;
            TestUtils.assertEquals((String)"exactly one event", (int)1, (int)report.getEventCount());
            TestUtils.assertEquals((String)"property", (String)property, (String)report.getLastProperty());
            if (verifyArrayItems && oldValue != null && oldValue.getClass().isArray()) {
                l1 = Arrays.asList((Object[])oldValue);
                l2 = Arrays.asList((Object[])report.getLastOldValue());
                TestUtils.assertEquals((String)"last old value", (int)l1.size(), (int)l2.size());
                for (i = 0; i < l1.size(); ++i) {
                    TestUtils.assertEquals((String)"last old value", (Object)l1.get(i), (Object)l2.get(i));
                }
            } else {
                TestUtils.assertEquals((String)"last old value", (Object)oldValue, (Object)report.getLastOldValue());
            }
            if (verifyArrayItems && newValue != null && newValue.getClass().isArray()) {
                l1 = Arrays.asList(newValue);
                l2 = Arrays.asList(report.getLastNewValue());
                TestUtils.assertEquals((String)"last new value", (int)l1.size(), (int)l2.size());
                for (i = 0; i < l1.size(); ++i) {
                    TestUtils.assertEquals((String)"last new value", (Object)l1.get(i), (Object)l2.get(i));
                }
            } else {
                TestUtils.assertEquals((String)"last new value", (Object)newValue, (Object)report.getLastNewValue());
            }
        } else {
            List<Object> l2;
            List<Object> l1;
            TestUtils.assertEquals((String)("one event of property " + property), (int)1, (int)report.getEventCount(property));
            if (verifyArrayItems && oldValue != null && oldValue.getClass().isArray()) {
                l1 = Arrays.asList((Object[])oldValue);
                l2 = Arrays.asList((Object[])report.getLastOldValue(property));
                TestUtils.assertEquals((String)"old value", (int)l1.size(), (int)l2.size());
                for (int i = 0; i < l1.size(); ++i) {
                    TestUtils.assertEquals((String)"old value", (Object)l1.get(i), (Object)l2.get(i));
                }
            } else {
                TestUtils.assertEquals((String)("old property " + property), (Object)oldValue, (Object)report.getLastOldValue(property));
            }
            if (verifyArrayItems && newValue != null && newValue.getClass().isArray()) {
                l1 = newValue instanceof Collection ? (List<Object>)newValue : Arrays.asList((Object[])newValue);
                l2 = report.getLastNewValue(property) instanceof Collection ? (List<Object>)report.getLastNewValue(property) : Arrays.asList((Object[])report.getLastNewValue(property));
                TestUtils.assertEquals((String)("new value of property " + property), (int)l1.size(), (int)l2.size());
                int index = 0;
                Iterator i1 = l1.iterator();
                Iterator i2 = l2.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    Object o1 = i1.next();
                    Object o2 = i2.next();
                    TestUtils.assertEquals((String)("new value [" + index++ + "] of property " + property), o1, o2);
                }
            } else {
                TestUtils.assertEquals((String)("new value of property " + property), (Object)newValue, (Object)report.getLastNewValue(property));
            }
        }
    }

    public static void assertPropertyChangeEvent(PropertyChangeReport report, String property, Object[] oldValue, Object[] newValue) {
        if (report.getEventCount() > 1) {
            LOG.info("events: " + report.getEventNames());
        }
        TestUtils.assertEquals((String)"exactly one event", (int)1, (int)report.getEventCount());
        TestUtils.assertEquals((String)"property", (String)property, (String)report.getLastProperty());
        TestUtils.assertTrue((String)"last old array value", (boolean)Arrays.equals(oldValue, (Object[])report.getLastOldValue()));
        TestUtils.assertTrue((String)"last new array value", (boolean)Arrays.equals(newValue, (Object[])report.getLastNewValue()));
    }
}

