/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.test.matchers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.hamcrest.CoreMatchers;
import org.mockito.ArgumentMatcher;

class EquivalentMatcher<T>
extends ArgumentMatcher<T> {
    private final T object;

    public EquivalentMatcher(T object) {
        this.object = object;
    }

    public boolean matches(Object argument) {
        if (CoreMatchers.equalTo(this.object).matches(argument)) {
            return true;
        }
        if (argument != null && this.object.getClass() == argument.getClass()) {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(this.object.getClass());
            }
            catch (IntrospectionException shouldNeverHappen) {
                throw new Error(shouldNeverHappen);
            }
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (pd.getReadMethod() == null) continue;
                Object value1 = null;
                try {
                    value1 = pd.getReadMethod().invoke(this.object, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    new Error(e);
                }
                Object value2 = null;
                try {
                    value2 = pd.getReadMethod().invoke(this.object, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception shouldNeverHappen) {
                    new Error(shouldNeverHappen);
                }
                if (CoreMatchers.equalTo((Object)value1).matches(value2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

