/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.test.matchers;

import java.beans.PropertyChangeEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;

class PropertyChangeEventMatcher
extends ArgumentMatcher<PropertyChangeEvent> {
    private final String propertyName;
    private final Object oldValue;
    private final Object newValue;

    public PropertyChangeEventMatcher(String propertyName, Object oldValue, Object newValue) {
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public boolean matches(Object argument) {
        if (argument instanceof PropertyChangeEvent) {
            PropertyChangeEvent pce = (PropertyChangeEvent)argument;
            boolean result = this.propertyName.equals(pce.getPropertyName());
            result &= this.oldValue == null || pce.getOldValue() == null || CoreMatchers.is((Object)this.oldValue).matches(pce.getOldValue());
            return result &= this.newValue == null || pce.getNewValue() == null || CoreMatchers.is((Object)this.newValue).matches(pce.getNewValue());
        }
        return false;
    }

    public void describeTo(Description description) {
        super.describeTo(description);
        description.appendText(" " + this.propertyName);
    }
}

