/*
 * Decompiled with CFR 0.152.
 */
package org.apachextras.camel.jboss;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.AbstractVirtualFileVisitor;

public class JBossPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration urls;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName()));
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Could not read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                url = (URL)urls.nextElement();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("URL from classloader: " + url));
                }
                VirtualFile packageNode = VFS.getChild((URI)url.toURI());
                packageNode.visit((VirtualFileVisitor)new MatchingClassVisitor(test, classes));
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Could not read entries in url: " + url), (Throwable)ioe);
            }
            catch (URISyntaxException use) {
                this.log.warn((Object)("Could not read entries in url: " + url), (Throwable)use);
            }
        }
    }

    private final class MatchingClassVisitor
    extends AbstractVirtualFileVisitor {
        private PackageScanFilter _filter;
        private Set<Class<?>> _classes;

        private MatchingClassVisitor(PackageScanFilter filter, Set<Class<?>> classes) {
            super(VisitorAttributes.RECURSE_LEAVES_ONLY);
            this._filter = filter;
            this._classes = classes;
        }

        public void visit(VirtualFile file) {
            if (file.getName().endsWith(".class")) {
                String fqn = file.getPathName();
                String qn = fqn.indexOf("jar/") != -1 ? fqn.substring(fqn.indexOf("jar/") + 4) : fqn.substring(fqn.indexOf("/") + 1);
                JBossPackageScanClassResolver.this.addIfMatching(this._filter, qn, this._classes);
            }
        }
    }
}

