/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.config.model.v1;

import javax.xml.namespace.QName;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQConnectorConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQDiscoveryGroupConfigModel;
import org.switchyard.component.hornetq.config.model.v1.V1NameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1HornetQConfigModel
extends BaseModel
implements HornetQConfigModel {
    public V1HornetQConfigModel() {
        super(new QName("urn:switchyard-component-hornetq:config:1.0", "config"));
        this.setModelChildrenOrder(new String[]{"ackBatchSize", "autoGroup", "blockOnAcknowledge", "blockOnDurableSend", "blockOnNonDurableSend", "cacheLargeMessagesOnConsumer", "callTimeout", "clientFailureCheckPeriod", "compressLargeMessages", "connectionLoadBalancingPolicyClassName", "connectionTTL", "confirmationWindowSize", "queue", "disableFinalizeCheck", "discoveryGroup", "failoverOnInitialConnection", "groupID", "initialMessagePacketSize", "initialReconnectAttempts", "maxRetryInterval", "minLargeMessageSize", "preAcknowledge", "producerMaxRate", "producerWindowSize", "reconnectAttempts", "retryInterval", "retryIntervalMultiplier", "scheduledThreadPoolMaxSize", "threadPoolMaxSize", "useGlobalPools", "useHA"});
    }

    public V1HornetQConfigModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public HornetQConfigModel setQueue(String destination) {
        this.setConfigValue(destination, "queue");
        return this;
    }

    @Override
    public String getQueue() {
        return this.getConfigValue("queue");
    }

    @Override
    public HornetQConnectorConfigModel getConnectorConfiguration() {
        return (HornetQConnectorConfigModel)this.getFirstChildModel("connector");
    }

    @Override
    public V1HornetQConfigModel setConnectorConfiguration(HornetQConnectorConfigModel config) {
        this.setChildModel(config);
        return this;
    }

    @Override
    public V1HornetQConfigModel setDiscoveryGroup(HornetQDiscoveryGroupConfigModel config) {
        this.setChildModel(config);
        return this;
    }

    @Override
    public HornetQDiscoveryGroupConfigModel getDiscoveryGroup() {
        return (HornetQDiscoveryGroupConfigModel)this.getFirstChildModel("discoveryGroup");
    }

    @Override
    public V1HornetQConfigModel disableFinalizeCheck() {
        this.setConfigValue("true", "disableFinalizeCheck");
        return this;
    }

    @Override
    public Boolean isDisableFinalizeCheck() {
        return this.getBooleanConfigValue("disableFinalizeCheck");
    }

    @Override
    public V1HornetQConfigModel setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        this.setConfigValue(String.valueOf(clientFailureCheckPeriod), "clientFailureCheckPeriod");
        return this;
    }

    @Override
    public Long getClientFailureCheckPeriod() {
        return this.getLongConfigValue("clientFailureCheckPeriod");
    }

    @Override
    public V1HornetQConfigModel setCacheLargeMessagesClient(Boolean cached) {
        this.setConfigValue(String.valueOf(cached), "cacheLargeMessagesOnConsumer");
        return this;
    }

    @Override
    public Boolean isCacheLargeMessagesClient() {
        return this.getBooleanConfigValue("cacheLargeMessagesOnConsumer");
    }

    @Override
    public Long getConnectionTTL() {
        return this.getLongConfigValue("connectionTTL");
    }

    @Override
    public V1HornetQConfigModel setConnectionTTL(Long connectionTTL) {
        this.setConfigValue(String.valueOf(connectionTTL), "connectionTTL");
        return this;
    }

    @Override
    public Long getCallTimeout() {
        return this.getLongConfigValue("callTimeout");
    }

    @Override
    public V1HornetQConfigModel setCallTimeout(Long callTimeout) {
        this.setConfigValue(String.valueOf(callTimeout), "callTimeout");
        return this;
    }

    @Override
    public V1HornetQConfigModel setMinLargeMessageSize(Integer minLargeMessageSize) {
        this.setConfigValue(String.valueOf(minLargeMessageSize), "minLargeMessageSize");
        return this;
    }

    @Override
    public Integer getMinLargeMessageSize() {
        return this.getIntegerConfigValue("minLargeMessageSize");
    }

    @Override
    public Integer getConsumerWindowSize() {
        return this.getIntegerConfigValue("consumerWindowSize");
    }

    @Override
    public HornetQConfigModel setConsumerWindowSize(Integer consumerWindowSize) {
        this.setConfigValue(String.valueOf(consumerWindowSize), "consumerWindowSize");
        return this;
    }

    @Override
    public Integer getConsumerMaxRate() {
        return this.getIntegerConfigValue("consumerMaxRate");
    }

    @Override
    public HornetQConfigModel setConsumerMaxRate(Integer consumerMaxRate) {
        this.setConfigValue(String.valueOf(consumerMaxRate), "consumerMaxRate");
        return this;
    }

    @Override
    public Integer getConfirmationWindowSize() {
        return this.getIntegerConfigValue("confirmationWindowSize");
    }

    @Override
    public HornetQConfigModel setConfirmationWindowSize(Integer confirmationWindowSize) {
        this.setConfigValue(String.valueOf(confirmationWindowSize), "confirmationWindowSize");
        return this;
    }

    @Override
    public Integer getProducerWindowSize() {
        return this.getIntegerConfigValue("producerWindowSize");
    }

    @Override
    public HornetQConfigModel setProducerWindowSize(Integer producerWindowSize) {
        this.setConfigValue(String.valueOf(producerWindowSize), "producerWindowSize");
        return this;
    }

    @Override
    public Integer getProducerMaxRate() {
        return this.getIntegerConfigValue("producerMaxRate");
    }

    @Override
    public HornetQConfigModel setProducerMaxRate(Integer producerMaxRate) {
        this.setConfigValue(String.valueOf(producerMaxRate), "producerMaxRate");
        return this;
    }

    @Override
    public Boolean isBlockOnAcknowledge() {
        return this.getBooleanConfigValue("blockOnAcknowledge");
    }

    @Override
    public HornetQConfigModel setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        this.setConfigValue(String.valueOf(blockOnAcknowledge), "blockOnAcknowledge");
        return this;
    }

    @Override
    public Boolean isBlockOnDurableSend() {
        return this.getBooleanConfigValue("blockOnDurableSend");
    }

    @Override
    public HornetQConfigModel setBlockOnDurableSend(Boolean blockOnDurableSend) {
        this.setConfigValue(String.valueOf(blockOnDurableSend), "blockOnDurableSend");
        return this;
    }

    @Override
    public Boolean isBlockOnNonDurableSend() {
        return this.getBooleanConfigValue("blockOnNonDurableSend");
    }

    @Override
    public HornetQConfigModel setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        this.setConfigValue(String.valueOf(blockOnNonDurableSend), "blockOnNonDurableSend");
        return this;
    }

    @Override
    public Boolean isAutoGroup() {
        return this.getBooleanConfigValue("autoGroup");
    }

    @Override
    public HornetQConfigModel setAutoGroup(Boolean autoGroup) {
        this.setConfigValue(String.valueOf(autoGroup), "autoGroup");
        return this;
    }

    @Override
    public String getGroupID() {
        return this.getConfigValue("groupID");
    }

    @Override
    public HornetQConfigModel setGroupID(String groupID) {
        this.setConfigValue(groupID, "groupID");
        return this;
    }

    @Override
    public Boolean isPreAcknowledge() {
        return this.getBooleanConfigValue("preAcknowledge");
    }

    @Override
    public HornetQConfigModel setPreAcknowledge(Boolean preAcknowledge) {
        this.setConfigValue(String.valueOf(preAcknowledge), "preAcknowledge");
        return this;
    }

    @Override
    public Integer getAckBatchSize() {
        return this.getIntegerConfigValue("ackBatchSize");
    }

    @Override
    public HornetQConfigModel setAckBatchSize(Integer ackBatchSize) {
        this.setConfigValue(String.valueOf(ackBatchSize), "ackBatchSize");
        return this;
    }

    @Override
    public Boolean isUseGlobalPools() {
        return this.getBooleanConfigValue("useGlobalPools");
    }

    @Override
    public HornetQConfigModel setUseGlobalPools(Boolean useGlobalPools) {
        this.setConfigValue(String.valueOf(useGlobalPools), "useGlobalPools");
        return this;
    }

    @Override
    public Integer getScheduledThreadPoolMaxSize() {
        return this.getIntegerConfigValue("scheduledThreadPoolMaxSize");
    }

    @Override
    public HornetQConfigModel setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        this.setConfigValue(String.valueOf(scheduledThreadPoolMaxSize), "scheduledThreadPoolMaxSize");
        return this;
    }

    @Override
    public Integer getThreadPoolMaxSize() {
        return this.getIntegerConfigValue("threadPoolMaxSize");
    }

    @Override
    public HornetQConfigModel setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        this.setConfigValue(String.valueOf(threadPoolMaxSize), "threadPoolMaxSize");
        return this;
    }

    @Override
    public Long getRetryInterval() {
        return this.getLongConfigValue("retryInterval");
    }

    @Override
    public HornetQConfigModel setRetryInterval(Long retryInterval) {
        this.setConfigValue(String.valueOf(retryInterval), "retryInterval");
        return this;
    }

    @Override
    public Double getRetryIntervalMultiplier() {
        return this.getDoubleConfigValue("retryIntervalMultiplier");
    }

    @Override
    public HornetQConfigModel setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        this.setConfigValue(String.valueOf(retryIntervalMultiplier), "retryIntervalMultiplier");
        return this;
    }

    @Override
    public Long getMaxRetryInterval() {
        return this.getLongConfigValue("maxRetryInterval");
    }

    @Override
    public HornetQConfigModel setMaxRetryInterval(Long maxRetryInterval) {
        this.setConfigValue(String.valueOf(maxRetryInterval), "maxRetryInterval");
        return this;
    }

    @Override
    public Integer getReconnectAttempts() {
        return this.getIntegerConfigValue("reconnectAttempts");
    }

    @Override
    public HornetQConfigModel setReconnectAttempts(Integer reconnectAttempts) {
        this.setConfigValue(String.valueOf(reconnectAttempts), "reconnectAttempts");
        return this;
    }

    @Override
    public V1HornetQConfigModel setInitialConnectAttempts(Integer reconnectAttempts) {
        this.setConfigValue(String.valueOf(reconnectAttempts), "initialReconnectAttempts");
        return this;
    }

    @Override
    public Integer getInitialConnectAttempts() {
        return this.getIntegerConfigValue("initialReconnectAttempts");
    }

    @Override
    public Boolean isFailoverOnInitialConnection() {
        return this.getBooleanConfigValue("failoverOnInitialConnection");
    }

    @Override
    public V1HornetQConfigModel setFailoverOnInitialConnection(Boolean failover) {
        this.setConfigValue(String.valueOf(failover), "failoverOnInitialConnection");
        return this;
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.getConfigValue("connectionLoadBalancingPolicyClassName");
    }

    @Override
    public V1HornetQConfigModel setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.setConfigValue(loadBalancingPolicyClassName, "connectionLoadBalancingPolicyClassName");
        return this;
    }

    @Override
    public Integer getInitialMessagePacketSize() {
        return this.getIntegerConfigValue("initialMessagePacketSize");
    }

    @Override
    public V1HornetQConfigModel setInitialMessagePacketSize(Integer size) {
        this.setConfigValue(String.valueOf(size), "initialMessagePacketSize");
        return this;
    }

    @Override
    public V1HornetQConfigModel setUseHA(Boolean useHA) {
        this.setConfigValue(String.valueOf(useHA), "useHA");
        return this;
    }

    @Override
    public Boolean isUseHA() {
        return this.getBooleanConfigValue("useHA");
    }

    @Override
    public Boolean isCompressLargeMessage() {
        return this.getBooleanConfigValue("compressLargeMessages");
    }

    @Override
    public V1HornetQConfigModel setCompressLargeMessage(Boolean compress) {
        this.setConfigValue(String.valueOf(compress), "compressLargeMessages");
        return this;
    }

    @Override
    public boolean isXASession() {
        return this.getBooleanConfigValue("xaSession", false);
    }

    @Override
    public HornetQConfigModel setXASession(boolean xa) {
        this.setConfigValue(String.valueOf(xa), "xaSession");
        return this;
    }

    private void setConfigValue(String value, String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        if (config != null) {
            config.setValue(value);
        } else {
            V1NameValueModel model = new V1NameValueModel(propertyName);
            model.setValue(value);
            this.setChildModel((Model)model);
        }
    }

    private String getConfigValue(String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        return config != null ? config.getValue() : null;
    }

    private Long getLongConfigValue(String propertyName) {
        String value = this.getConfigValue(propertyName);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    private Double getDoubleConfigValue(String propertyName) {
        String value = this.getConfigValue(propertyName);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    private Boolean getBooleanConfigValue(String propertyName) {
        String value = this.getConfigValue(propertyName);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private Boolean getBooleanConfigValue(String propertyName, boolean defaultValue) {
        String value = this.getConfigValue(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private Integer getIntegerConfigValue(String propertyName) {
        String value = this.getConfigValue(propertyName);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }
}

