/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.deploy;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.component.hornetq.config.model.HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.internal.HornetQUtil;
import org.switchyard.exception.SwitchYardException;

public class OutboundHandler
extends BaseHandler {
    private final ServerLocator _serverLocator;
    private ClientSessionFactory _factory;
    private ClientSession _session;
    private ClientProducer _producer;
    private HornetQConfigModel _configModel;

    public OutboundHandler(HornetQBindingModel model, ServerLocator serverLocator) {
        this._configModel = model.getHornetQConfig();
        this._serverLocator = serverLocator;
    }

    public void start() {
        try {
            this._factory = this._serverLocator.createSessionFactory();
            this._session = this._configModel.isXASession() ? this._factory.createXASession() : this._factory.createSession();
            this._producer = this._session.createProducer(this._configModel.getQueue());
            this._session.start();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        ClientMessage message = this._session.createMessage(true);
        byte[] content = (byte[])exchange.getMessage().getContent(byte[].class);
        message.getBodyBuffer().writeBytes(content);
        try {
            this._producer.send((Message)message);
        }
        catch (HornetQException e) {
            throw new HandlerException((Throwable)e);
        }
    }

    public void stop() {
        HornetQUtil.closeClientProducer(this._producer);
        HornetQUtil.closeSession(this._session);
        HornetQUtil.closeSessionFactory(this._factory);
        HornetQUtil.closeServerLocator(this._serverLocator);
    }
}

