/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq;

import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.switchyard.component.hornetq.HornetQComponent;
import org.switchyard.component.hornetq.HornetQConsumer;
import org.switchyard.component.hornetq.HornetQProducer;
import org.switchyard.component.hornetq.ServerLocatorBuilder;

public class HornetQEndpoint
extends DefaultEndpoint {
    private String _queue;
    private ServerLocatorBuilder _serverLocatorBuilder;
    private boolean _xa;
    private boolean _durable;

    public HornetQEndpoint(String queue, String uri, HornetQComponent component, ServerLocatorBuilder serverLocatorBuilder) {
        super(uri, (Component)component);
        this._queue = queue;
        this._serverLocatorBuilder = serverLocatorBuilder;
    }

    public HornetQConsumer createConsumer(Processor processor) throws Exception {
        return new HornetQConsumer(this, processor, this._serverLocatorBuilder.build(), this._queue);
    }

    public HornetQProducer createProducer() throws Exception {
        return new HornetQProducer(this, this._serverLocatorBuilder.build(), this._queue);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getQueueName() {
        return this._queue;
    }

    public void setTransportConfiguration(TransportConfiguration config) {
        this._serverLocatorBuilder.transportConfigurations(config);
    }

    public void setDiscoveryGroupConfiguration(DiscoveryGroupConfiguration config) {
        this._serverLocatorBuilder.discoveryGroupConfiguration(config);
    }

    public void setUseHA(Boolean useHA) {
        this._serverLocatorBuilder.useHA(useHA);
    }

    public void setDisableFinalizedCheck(Boolean disable) {
        this._serverLocatorBuilder.disableFinalizedCheck(disable);
    }

    public void setClientFailureCheckPeriod(Long period) {
        this._serverLocatorBuilder.clientFailureCheckPeriod(period);
    }

    public void setCacheLargeMessagesOnConsumer(Boolean cache) {
        this._serverLocatorBuilder.cacheLargeMessagesOnConsumers(cache);
    }

    public void setConnectionTTL(Long ttl) {
        this._serverLocatorBuilder.connectionTTL(ttl);
    }

    public void setCallTimeout(Long timeout) {
        this._serverLocatorBuilder.callTimeout(timeout);
    }

    public void setMinLargeMessageSize(Integer size) {
        this._serverLocatorBuilder.minLargeMessageSize(size);
    }

    public void setConsumerWindowSize(Integer size) {
        this._serverLocatorBuilder.consumerWindowSize(size);
    }

    public void setConsumerMaxRate(Integer rate) {
        this._serverLocatorBuilder.consumerMaxRate(rate);
    }

    public void setConfirmationWindowSize(Integer size) {
        this._serverLocatorBuilder.confirmationWindowSize(size);
    }

    public void setProducerWindowSize(Integer size) {
        this._serverLocatorBuilder.producerWindowSize(size);
    }

    public void setProducerMaxRate(Integer rate) {
        this._serverLocatorBuilder.producerMaxRate(rate);
    }

    public void setBlockOnAcknowledge(Boolean block) {
        this._serverLocatorBuilder.blockOnAcknowledge(block);
    }

    public void setBlockOnDurableSend(Boolean block) {
        this._serverLocatorBuilder.blockOnDurableSend(block);
    }

    public void setBlockOnNonDurableSend(Boolean block) {
        this._serverLocatorBuilder.blockOnNonDurableSend(block);
    }

    public void setAutoGroup(Boolean autoGroup) {
        this._serverLocatorBuilder.autoGroup(autoGroup);
    }

    public void setGroupID(String id) {
        this._serverLocatorBuilder.groupID(id);
    }

    public void setPreAcknowledge(Boolean preAck) {
        this._serverLocatorBuilder.preAcknowledge(preAck);
    }

    public void setAckBatchSize(Integer size) {
        this._serverLocatorBuilder.ackBatchSize(size);
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        this._serverLocatorBuilder.useGlobalPools(useGlobalPools);
    }

    public void setScheduledThreadPoolMaxSize(Integer size) {
        this._serverLocatorBuilder.scheduledThreadPoolMaxSize(size);
    }

    public void setThreadPoolMaxSize(Integer size) {
        this._serverLocatorBuilder.threadPoolMaxSize(size);
    }

    public void setRetryInterval(Long interval) {
        this._serverLocatorBuilder.retryInterval(interval);
    }

    public void setRetryIntervalMultiplier(Double multiplier) {
        this._serverLocatorBuilder.retryIntervalMultiplier(multiplier);
    }

    public void setMaxRetryInterval(Long max) {
        this._serverLocatorBuilder.maxRetryInterval(max);
    }

    public void setReconnectAttempts(Integer attempts) {
        this._serverLocatorBuilder.reconnectAttempts(attempts);
    }

    public void setInitialReconnectAttempts(Integer attempts) {
        this._serverLocatorBuilder.initialReconnectAttempts(attempts);
    }

    public void setFailoverOnInitialConnection(Boolean failover) {
        this._serverLocatorBuilder.failoverOnInitialConnection(failover);
    }

    public void setConnectionLoadBalancingPolicyClassName(String className) {
        this._serverLocatorBuilder.connectionLoadBalancingPolicyClassName(className);
    }

    public void setInitialMessagePacketSize(Integer packetSize) {
        this._serverLocatorBuilder.initialMessagePacketSize(packetSize);
    }

    public void setCompessLargeMessage(Boolean compress) {
        this._serverLocatorBuilder.compressLargeMessage(compress);
    }

    public void setXASession(boolean xa) {
        this._xa = xa;
    }

    public boolean isXASession() {
        return this._xa;
    }

    public void setDurable(boolean durable) {
        this._durable = durable;
    }

    public boolean isDurable() {
        return this._durable;
    }
}

