/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.composer;

import org.hornetq.api.core.client.ClientMessage;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.hornetq.internal.HornetQUtil;
import org.switchyard.composer.BaseMessageComposer;

public class HornetQMessageComposer
extends BaseMessageComposer<ClientMessage> {
    public Message compose(ClientMessage source, Exchange exchange, boolean create) throws Exception {
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((Object)source, exchange.getContext());
        message.setContent((Object)HornetQUtil.readBytes(source));
        return message;
    }

    public ClientMessage decompose(Exchange exchange, ClientMessage target) throws Exception {
        this.getContextMapper().mapTo(exchange.getContext(), (Object)target);
        byte[] content = (byte[])exchange.getMessage().getContent(byte[].class);
        target.getBodyBuffer().writeBytes(content);
        return target;
    }
}

