/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.internal;

import org.apache.log4j.Logger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;

public final class HornetQUtil {
    private static Logger _logger = Logger.getLogger(HornetQUtil.class);

    private HornetQUtil() {
    }

    public static void closeServerLocator(ServerLocator serverLocator) {
        if (serverLocator != null) {
            serverLocator.close();
        }
    }

    public static void closeSessionFactory(ClientSessionFactory factory) {
        if (factory != null) {
            factory.close();
        }
    }

    public static void closeSession(ClientSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (HornetQException e) {
                _logger.warn((Object)("Exception while trying to close ClientSession: " + session), (Throwable)e);
            }
        }
    }

    public static void closeClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (HornetQException e) {
                _logger.warn((Object)("Exception while trying to close ClientConsumer: " + consumer), (Throwable)e);
            }
        }
    }

    public static void closeClientProducer(ClientProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (HornetQException e) {
                _logger.warn((Object)("Exception while trying to close ClientProducer: " + producer), (Throwable)e);
            }
        }
    }

    public static byte[] readBytes(ClientMessage msg) throws Exception {
        byte[] bytes = new byte[msg.getBodySize()];
        HornetQBuffer bodyBuffer = msg.getBodyBuffer();
        bodyBuffer.readBytes(bytes);
        return bytes;
    }
}

