/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.switchyard.component.hornetq.HornetQEndpoint;
import org.switchyard.component.hornetq.internal.HornetQUtil;

public class HornetQConsumer
extends DefaultConsumer
implements MessageHandler,
SessionFailureListener {
    private final String _destination;
    private ClientSession _session;
    private ClientConsumer _consumer;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _factory;
    private final HornetQEndpoint _hornetQEndpoint;

    public HornetQConsumer(HornetQEndpoint endpoint, Processor processor, ServerLocator serverLocator, String destination) {
        super((Endpoint)endpoint, processor);
        this._hornetQEndpoint = endpoint;
        this._destination = destination;
        this._serverLocator = serverLocator;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._factory = this._serverLocator.createSessionFactory();
        this._session = this._hornetQEndpoint.isXASession() ? this._factory.createXASession() : this._factory.createSession();
        this._consumer = this._session.createConsumer(this._destination);
        this._consumer.setMessageHandler((MessageHandler)this);
        this._session.addFailureListener((SessionFailureListener)this);
        this._session.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            HornetQUtil.closeClientConsumer(this._consumer);
            HornetQUtil.closeSession(this._session);
            HornetQUtil.closeSessionFactory(this._factory);
            HornetQUtil.closeServerLocator(this._serverLocator);
        }
    }

    public void onMessage(ClientMessage message) {
        Exchange exchange = this.getEndpoint().createExchange();
        byte[] bytes = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(bytes);
        exchange.getIn().setBody((Object)bytes);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }

    public void connectionFailed(HornetQException exception, boolean failedOver) {
        if (!failedOver) {
            this.getExceptionHandler().handleException((Throwable)exception);
        }
    }

    public void beforeReconnect(HornetQException exception) {
    }
}

