/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.composer;

import org.hornetq.api.core.PropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.hornetq.composer.HornetQBindingData;

public class HornetQContextMapper
extends BaseRegexContextMapper<HornetQBindingData> {
    public void mapFrom(HornetQBindingData source, Context context) throws Exception {
        ClientMessage clientMessage = source.getClientMessage();
        for (SimpleString key : clientMessage.getPropertyNames()) {
            Object value;
            String name = key.toString();
            if (!this.matches(name) || (value = clientMessage.getObjectProperty(key)) == null) continue;
            context.setProperty(name, value, Scope.EXCHANGE).addLabels(new String[]{"hornetq_message_property"});
        }
    }

    public void mapTo(Context context, HornetQBindingData target) throws Exception {
        ClientMessage clientMessage = target.getClientMessage();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            try {
                clientMessage.putObjectProperty(name, value);
            }
            catch (PropertyConversionException pce) {
                pce.getMessage();
            }
        }
    }
}

