/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.config.model.v1;

import javax.xml.namespace.QName;
import org.switchyard.component.hornetq.config.model.HornetQDiscoveryGroupConfigModel;
import org.switchyard.component.hornetq.config.model.v1.V1NameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V1DiscoveryGroupConfigModel
extends BaseModel
implements HornetQDiscoveryGroupConfigModel {
    public V1DiscoveryGroupConfigModel() {
        super(new QName("urn:switchyard-component-hornetq:config:1.0", "discoveryGroup"));
        this.setModelChildrenOrder(new String[]{"localBindAddress", "groupAddress", "groupPort", "refreshTimeout", "initialWaitTimeout"});
    }

    public V1DiscoveryGroupConfigModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public HornetQDiscoveryGroupConfigModel setLocalBindAddress(String address) {
        this.setConfigValue(address, "localBindAddress");
        return this;
    }

    @Override
    public String getLocalBindAddress() {
        return this.getConfigValue("localBindAddress");
    }

    @Override
    public HornetQDiscoveryGroupConfigModel setGroupAddress(String address) {
        this.setConfigValue(address, "groupAddress");
        return this;
    }

    @Override
    public String getGroupAddress() {
        return this.getConfigValue("groupAddress");
    }

    @Override
    public HornetQDiscoveryGroupConfigModel setGroupPort(Integer port) {
        this.setConfigValue(String.valueOf(port), "groupPort");
        return this;
    }

    @Override
    public Integer getGroupPort() {
        return this.getIntegerConfigValue("groupPort");
    }

    @Override
    public HornetQDiscoveryGroupConfigModel setRefreshTimeout(Long timeout) {
        this.setConfigValue(String.valueOf(timeout), "refreshTimeout");
        return this;
    }

    @Override
    public Long getRefreshTimeout() {
        return this.getLongConfigValue("refreshTimeout");
    }

    @Override
    public HornetQDiscoveryGroupConfigModel setInitialWaitTimeout(Long timeout) {
        this.setConfigValue(String.valueOf(timeout), "initialWaitTimeout");
        return this;
    }

    @Override
    public Long getInitialWaitTimeout() {
        return this.getLongConfigValue("initialWaitTimeout");
    }

    private void setConfigValue(String value, String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        if (config != null) {
            config.setValue(value);
        } else {
            V1NameValueModel model = new V1NameValueModel(propertyName);
            model.setValue(value);
            this.setChildModel((Model)model);
        }
    }

    private String getConfigValue(String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        return config != null ? config.getValue() : null;
    }

    private Integer getIntegerConfigValue(String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        return config != null ? Integer.valueOf(config.getValue()) : null;
    }

    private Long getLongConfigValue(String propertyName) {
        Configuration config = this.getModelConfiguration().getFirstChild(propertyName);
        return config != null ? Long.valueOf(config.getValue()) : null;
    }
}

