/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;

public class JMSMessageComposer
extends BaseMessageComposer<JMSBindingData> {
    public Message compose(JMSBindingData source, Exchange exchange) throws Exception {
        Message syMessage = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(syMessage));
        javax.jms.Message jmsMessage = source.getMessage();
        if (jmsMessage instanceof BytesMessage) {
            BytesMessage sourceBytes = (BytesMessage)BytesMessage.class.cast(jmsMessage);
            if (sourceBytes.getBodyLength() > Integer.MAX_VALUE) {
                throw JCAMessages.MESSAGES.theSizeOfMessageContentExceedsBytesThatIsNotSupportedByThisMessageComposer(new String("2147483647"));
            }
            byte[] bytearr = new byte[(int)sourceBytes.getBodyLength()];
            sourceBytes.readBytes(bytearr);
            syMessage.setContent((Object)bytearr);
        } else if (jmsMessage instanceof MapMessage) {
            MapMessage sourceMap = (MapMessage)MapMessage.class.cast(jmsMessage);
            HashMap<String, Object> body = new HashMap<String, Object>();
            Enumeration e = sourceMap.getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)String.class.cast(e.nextElement());
                body.put(key, sourceMap.getObject(key));
            }
            syMessage.setContent(body);
        } else if (jmsMessage instanceof ObjectMessage) {
            ObjectMessage sourceObj = (ObjectMessage)ObjectMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceObj.getObject());
        } else if (jmsMessage instanceof StreamMessage) {
            StreamMessage sourceStream = (StreamMessage)StreamMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceStream);
        } else if (jmsMessage instanceof TextMessage) {
            TextMessage sourceText = (TextMessage)TextMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceText.getText());
        } else {
            syMessage.setContent(null);
        }
        return syMessage;
    }

    public JMSBindingData decompose(Exchange exchange, JMSBindingData target) throws Exception {
        block6: {
            javax.jms.Message jmsMessage;
            Message syMessage;
            block9: {
                block8: {
                    block7: {
                        block5: {
                            syMessage = exchange.getMessage();
                            this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
                            jmsMessage = target.getMessage();
                            if (!(jmsMessage instanceof ObjectMessage)) break block5;
                            ObjectMessage msg = (ObjectMessage)ObjectMessage.class.cast(jmsMessage);
                            msg.setObject((Serializable)syMessage.getContent(Serializable.class));
                            break block6;
                        }
                        if (!(jmsMessage instanceof TextMessage)) break block7;
                        TextMessage msg = (TextMessage)TextMessage.class.cast(jmsMessage);
                        msg.setText((String)syMessage.getContent(String.class));
                        break block6;
                    }
                    if (!(jmsMessage instanceof BytesMessage)) break block8;
                    BytesMessage msg = (BytesMessage)BytesMessage.class.cast(jmsMessage);
                    msg.writeBytes((byte[])syMessage.getContent(byte[].class));
                    break block6;
                }
                if (!(jmsMessage instanceof StreamMessage)) break block9;
                StreamMessage msg = (StreamMessage)StreamMessage.class.cast(jmsMessage);
                byte[] buffer = new byte[8192];
                int size = 0;
                if (syMessage.getContent() instanceof StreamMessage) {
                    StreamMessage sm = (StreamMessage)syMessage.getContent(StreamMessage.class);
                    while ((size = sm.readBytes(buffer)) > 0) {
                        msg.writeBytes(buffer, 0, size);
                    }
                } else {
                    InputStream is = (InputStream)syMessage.getContent(InputStream.class);
                    while ((size = is.read(buffer)) > 0) {
                        msg.writeBytes(buffer, 0, size);
                    }
                }
                break block6;
            }
            if (!(jmsMessage instanceof MapMessage)) break block6;
            MapMessage msg = (MapMessage)MapMessage.class.cast(jmsMessage);
            Map map = (Map)syMessage.getContent(Map.class);
            for (Object key : map.keySet()) {
                msg.setObject(key.toString(), map.get(key));
            }
        }
        return target;
    }
}

