/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.jca.composer.StreamableRecordBindingData;
import org.switchyard.component.jca.processor.cci.StreamableRecord;

public class StreamableRecordContextMapper
extends BaseRegexContextMapper<StreamableRecordBindingData> {
    private static final String[] STREAMABLE_RECORD_LABELS = new String[]{ComponentLabel.JCA.label(), EndpointLabel.JCA.label()};

    public void mapFrom(StreamableRecordBindingData source, Context context) throws Exception {
        String recordDescription;
        StreamableRecord record = source.getRecord();
        String recordName = record.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName).addLabels(STREAMABLE_RECORD_LABELS);
        }
        if ((recordDescription = record.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription).addLabels(STREAMABLE_RECORD_LABELS);
        }
    }

    public void mapTo(Context context, StreamableRecordBindingData target) throws Exception {
        StreamableRecord record = target.getRecord();
        for (Property property : context.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                record.setRecordName(value.toString());
                continue;
            }
            if (!name.equals("recordShortDescription")) continue;
            record.setRecordShortDescription(value.toString());
        }
    }
}

