/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JCABindingData;
import org.switchyard.component.jca.composer.JCAComposition;
import org.switchyard.component.jca.config.model.JCABindingModel;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;
import org.switchyard.selector.OperationSelector;

public abstract class AbstractInflowEndpoint {
    private JCABindingModel _jcaBindingModel;
    private ServiceDomain _domain;
    private QName _serviceQName;
    private ServiceReference _serviceRef;
    private boolean _transacted = false;
    private ClassLoader _appClassLoader;
    private String _gatewayName;

    public void initialize() {
        this._serviceRef = this._domain.getServiceReference(this._serviceQName);
    }

    public void uninitialize() {
    }

    public AbstractInflowEndpoint setJCABindingModel(JCABindingModel model) {
        this._jcaBindingModel = model;
        this._gatewayName = model.getName();
        return this;
    }

    public JCABindingModel getJCABindingModel() {
        return this._jcaBindingModel;
    }

    public AbstractInflowEndpoint setServiceDomain(ServiceDomain domain) {
        this._domain = domain;
        return this;
    }

    public ServiceDomain getServiceDomain() {
        return this._domain;
    }

    public AbstractInflowEndpoint setServiceQName(QName qname) {
        this._serviceQName = qname;
        return this;
    }

    public QName getServiceQName() {
        return this._serviceQName;
    }

    public AbstractInflowEndpoint setServiceReference(ServiceReference ref) {
        this._serviceRef = ref;
        return this;
    }

    public ServiceReference getServiceReference() {
        return this._serviceRef;
    }

    public boolean isDeliveryTransacted() {
        return this._transacted;
    }

    public AbstractInflowEndpoint setDeliveryTransacted(boolean transacted) {
        this._transacted = transacted;
        return this;
    }

    public AbstractInflowEndpoint setApplicationClassLoader(ClassLoader loader) {
        this._appClassLoader = loader;
        return this;
    }

    public ClassLoader getApplicationClassLoader() {
        return this._appClassLoader;
    }

    protected Exchange createExchange(String operation, ExchangeHandler handler) {
        if (this._serviceRef == null) {
            throw JCAMessages.MESSAGES.initializeMustBeCalledBeforeExchange();
        }
        if (operation == null) {
            Set operations = this._serviceRef.getInterface().getOperations();
            if (operations.size() != 1) {
                throw JCAMessages.MESSAGES.noOperationSelectorConfigured(operations.toString());
            }
            ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
            operation = serviceOperation.getName();
        }
        Exchange exchange = this._serviceRef.createExchange(operation, handler);
        if (this._transacted) {
            PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
            PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        }
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        return exchange;
    }

    protected Exchange createExchange(String operation) {
        return this.createExchange(operation, null);
    }

    protected <D extends JCABindingData> MessageComposer<D> getMessageComposer(Class<D> clazz) {
        return JCAComposition.getMessageComposer(this._jcaBindingModel, clazz);
    }

    protected <D extends JCABindingData> OperationSelector<D> getOperationSelector(Class<D> clazz) {
        return OperationSelectorFactory.getOperationSelectorFactory(clazz).newOperationSelector(this._jcaBindingModel.getOperationSelector());
    }
}

