/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.hornetq;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.registry.JndiBindingRegistry;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.switchyard.component.test.mixins.naming.NamingMixIn;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.mixins.AbstractTestMixIn;

@MixInDependencies(required={NamingMixIn.class})
public class HornetQMixIn
extends AbstractTestMixIn {
    private static final String HORNETQ_CONF_FILE = "hornetq-configuration.xml";
    private static final String HORNETQ_JMS_CONF_FILE = "hornetq-jms.xml";
    private Logger _logger = Logger.getLogger(HornetQMixIn.class);
    private boolean _startEmbedded;
    private String _host = "localhost";
    private int _port = 5445;
    private String _user = null;
    private String _passwd = null;
    private EmbeddedJMS _embeddedJMS;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _clientSessionFactory;
    private ClientSession _clientSession;
    private HornetQConnectionFactory _jmsConnectionFactory;
    private Connection _jmsConnection;
    private Session _jmsSession;

    public HornetQMixIn() {
        this(true);
    }

    public HornetQMixIn(boolean embedded) {
        this._startEmbedded = embedded;
    }

    public void initialize() {
        super.initialize();
        if (this._startEmbedded) {
            this._embeddedJMS = new EmbeddedJMS();
            this._embeddedJMS.setConfigResourcePath(HORNETQ_CONF_FILE);
            this._embeddedJMS.setJmsConfigResourcePath(HORNETQ_JMS_CONF_FILE);
            try {
                this._embeddedJMS.setRegistry((BindingRegistry)new JndiBindingRegistry());
                this._embeddedJMS.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public HornetQMixIn setHost(String host) {
        this._host = host;
        return this;
    }

    public HornetQMixIn setPort(int port) {
        this._port = port;
        return this;
    }

    public HornetQMixIn setUser(String user) {
        this._user = user;
        return this;
    }

    public HornetQMixIn setPassword(String passwd) {
        this._passwd = passwd;
        return this;
    }

    public Configuration getConfiguration() {
        if (this._embeddedJMS == null) {
            return null;
        }
        return this._embeddedJMS.getHornetQServer().getConfiguration();
    }

    private static TransportConfiguration[] getTransports(Configuration from) {
        Collection transports = from.getConnectorConfigurations().values();
        return transports.toArray(new TransportConfiguration[0]);
    }

    public void uninitialize() {
        try {
            HornetQMixIn.closeSession(this._clientSession);
            HornetQMixIn.closeSessionFactory(this._clientSessionFactory);
            HornetQMixIn.closeServerLocator(this._serverLocator);
            HornetQMixIn.closeJMSSession(this._jmsSession);
            HornetQMixIn.closeJMSConnection(this._jmsConnection);
            HornetQMixIn.closeJMSConnectionFactory(this._jmsConnectionFactory);
            if (this._embeddedJMS != null) {
                this._embeddedJMS.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            super.uninitialize();
        }
    }

    public ClientSession getClientSession() {
        if (this._clientSession != null) {
            return this._clientSession;
        }
        return this.createClientSession();
    }

    public ClientSession createClientSession() {
        HornetQMixIn.closeSession(this._clientSession);
        try {
            if (this._serverLocator == null || this._clientSessionFactory == null) {
                if (this._startEmbedded) {
                    this._serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])HornetQMixIn.getTransports(this.getConfiguration()));
                    this._clientSessionFactory = this._serverLocator.createSessionFactory();
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("host", this._host);
                    params.put("port", this._port);
                    this._serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), params)});
                    this._clientSessionFactory = this._serverLocator.createSessionFactory();
                }
            }
            this._clientSession = this._clientSessionFactory.createSession(this._user, this._passwd, false, true, true, this._serverLocator.isPreAcknowledge(), this._serverLocator.getAckBatchSize());
            this._clientSession.start();
            return this._clientSession;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientMessage createMessage(String body) {
        ClientMessage message = this.getClientSession().createMessage(true);
        message.getBodyBuffer().writeBytes(body.getBytes());
        return message;
    }

    public ClientMessage createMessageFromResource(String path) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        String payload = this.getStringFromInputStream(stream);
        return this.createMessage(payload);
    }

    public Object readObjectFromMessage(ClientMessage msg) throws Exception {
        byte[] bytes = new byte[msg.getBodySize()];
        HornetQBuffer bodyBuffer = msg.getBodyBuffer();
        bodyBuffer.readBytes(bytes);
        Object result = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            result = in.readObject();
        }
        catch (Exception e) {
            this._logger.warn((Object)"Caught an Exception during deserializing object. Then trying to read as String");
            this._logger.debug((Object)"", (Throwable)e);
            result = new String(bytes);
        }
        return result;
    }

    public String readMessageAndTestString(ClientMessage msg, String expected) throws Exception {
        Object payload = this.readObjectFromMessage(msg);
        Assert.assertTrue((boolean)(payload instanceof String));
        Assert.assertEquals((String)expected, (String)((String)payload));
        return (String)payload;
    }

    public Session getJMSSession() {
        if (this._jmsSession != null) {
            return this._jmsSession;
        }
        return this.createJMSSession();
    }

    public Session createJMSSession() {
        HornetQMixIn.closeJMSSession(this._jmsSession);
        try {
            if (this._jmsConnectionFactory == null || this._jmsConnection == null) {
                if (this._startEmbedded) {
                    this._jmsConnectionFactory = new HornetQConnectionFactory(false, HornetQMixIn.getTransports(this.getConfiguration()));
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("host", this._host);
                    params.put("port", this._port);
                    this._jmsConnectionFactory = new HornetQConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), params)});
                }
                this._jmsConnection = this._jmsConnectionFactory.createConnection(this._user, this._passwd);
                this._jmsConnection.start();
            }
            this._jmsSession = this._jmsConnection.createSession(false, 1);
            return this._jmsSession;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectMessage createJMSMessage(String body) throws JMSException {
        return this._jmsSession.createObjectMessage((Serializable)((Object)body));
    }

    public Message createJMSMessageFromResource(String path) throws JMSException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        String payload = this.getStringFromInputStream(stream);
        return this.createJMSMessage(payload);
    }

    public Object readObjectFromJMSMessage(Message msg) throws JMSException {
        Assert.assertTrue((boolean)(msg instanceof ObjectMessage));
        ObjectMessage objMsg = (ObjectMessage)msg;
        return objMsg.getObject();
    }

    public byte[] readBytesFromJMSMessage(Message msg) throws JMSException {
        Assert.assertTrue((boolean)(msg instanceof BytesMessage));
        BytesMessage bsMsg = (BytesMessage)msg;
        if (bsMsg.getBodyLength() >= Integer.MAX_VALUE) {
            Assert.fail((String)("Message body is too large[" + bsMsg.getBodyLength() + "]: extract it manually."));
        }
        byte[] ba = new byte[(int)bsMsg.getBodyLength()];
        bsMsg.readBytes(ba);
        return ba;
    }

    public String readStringFromJMSMessage(Message msg) throws JMSException {
        if (msg instanceof TextMessage) {
            TextMessage txt = (TextMessage)msg;
            return txt.getText();
        }
        if (msg instanceof ObjectMessage) {
            return (String)this.readObjectFromJMSMessage(msg);
        }
        if (msg instanceof BytesMessage) {
            return new String(this.readBytesFromJMSMessage(msg));
        }
        throw new RuntimeException("The message body could not be extracted as String: " + msg);
    }

    public String readJMSMessageAndTestString(Message msg, String expected) throws JMSException {
        String payload = this.readStringFromJMSMessage(msg);
        Assert.assertEquals((String)expected, (String)payload);
        return payload;
    }

    public static void closeServerLocator(ServerLocator serverLocator) {
        if (serverLocator != null) {
            serverLocator.close();
        }
    }

    public static void closeSessionFactory(ClientSessionFactory factory) {
        if (factory != null) {
            factory.close();
        }
    }

    public static void closeSession(ClientSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeClientProducer(ClientProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeJMSConnectionFactory(HornetQConnectionFactory cf) {
        if (cf != null) {
            cf.close();
        }
    }

    public static void closeJMSConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (JMSException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeJMSSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeJMSConsumer(MessageConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (JMSException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeJMSProducer(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (JMSException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static Queue getJMSQueue(String name) {
        return new HornetQQueue(name);
    }

    private String getStringFromInputStream(InputStream source) {
        StringWriter writer = new StringWriter();
        Reader reader = null;
        char[] buffer = new char[1024];
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader(source, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
        }
        return ((Object)writer).toString();
    }
}

