/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class HTTPMixIn
extends AbstractTestMixIn {
    private static Logger _logger = Logger.getLogger(HTTPMixIn.class);
    public static final String HTTP_DELETE = "DELETE";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_HEAD = "HEAD";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_OPTIONS = "OPTIONS";
    private HttpClient _httpClient;
    private String _contentType = "text/xml;charset=UTF-8";
    private HashMap<String, String> _requestHeaders = new HashMap();
    private HashMap<String, String> _expectedHeaders = new HashMap();
    private boolean _dumpMessages = false;

    public HTTPMixIn setContentType(String contentType) {
        this._contentType = contentType;
        return this;
    }

    public void initialize() {
        this._httpClient = new HttpClient();
    }

    public int sendStringAndGetStatus(String endpointURL, String request, String method) {
        HttpMethod httpMethod = this.sendStringAndGetMethod(endpointURL, request, method);
        int status = httpMethod.getStatusCode();
        httpMethod.releaseConnection();
        return status;
    }

    public String sendString(String endpointURL, String request, String method) {
        String response = null;
        try {
            HttpMethod httpMethod = this.sendStringAndGetMethod(endpointURL, request, method);
            response = httpMethod.getResponseBodyAsString();
            httpMethod.releaseConnection();
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response", (Throwable)ioe);
        }
        return response;
    }

    public HttpMethod sendStringAndGetMethod(String endpointURL, String request, String method) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a " + method + " request to [" + endpointURL + "]"));
            _logger.info((Object)("Request body:[" + request + "]"));
        }
        Object httpMethod = null;
        try {
            if (method.equals(HTTP_PUT)) {
                httpMethod = new PutMethod(endpointURL);
                httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(request, this._contentType, "UTF-8"));
            } else if (method.equals(HTTP_POST)) {
                httpMethod = new PostMethod(endpointURL);
                ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(request, this._contentType, "UTF-8"));
            } else {
                httpMethod = method.equals(HTTP_DELETE) ? new DeleteMethod(endpointURL) : (method.equals(HTTP_OPTIONS) ? new OptionsMethod(endpointURL) : (method.equals(HTTP_HEAD) ? new HeadMethod(endpointURL) : new GetMethod(endpointURL)));
            }
            this.execute((HttpMethod)httpMethod);
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Unable to set request entity", (Throwable)e);
        }
        return httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postString(String endpointURL, String request) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            _logger.info((Object)("Request body:[" + request + "]"));
        }
        PostMethod postMethod = new PostMethod(endpointURL);
        try {
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(request, this._contentType, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Unable to set request entity", (Throwable)e);
        }
        try {
            String string = this.execute((HttpMethod)postMethod);
            return string;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postFile(String endpointURL, String request) {
        FileRequestEntity requestEntity = new FileRequestEntity(new File(request), "text/xml; charset=utf-8");
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            ByteArrayOutputStream target = new ByteArrayOutputStream();
            try {
                requestEntity.writeRequest((OutputStream)target);
                _logger.info((Object)("Request body:[" + target.toString() + "]"));
            }
            catch (IOException e) {
                _logger.error((Object)"Unable to write FileRequestEntity to stream", (Throwable)e);
            }
        }
        PostMethod postMethod = new PostMethod(endpointURL);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        try {
            String string = this.execute((HttpMethod)postMethod);
            return string;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public String postStringAndTestXML(String endpointURL, String request, String expectedResponse) {
        String response = this.postString(endpointURL, request);
        SwitchYardTestKit.compareXMLToString((String)response, (String)expectedResponse);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpMethod postResourceAndGetMethod(String endpointURL, String requestResource) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            InputStream input = this.getTestKit().getResourceAsStream(requestResource);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int l = 0;
            try {
                while ((l = input.read(data)) >= 0) {
                    tmp.write(data, 0, l);
                }
                _logger.info((Object)("Request body:[" + new String(tmp.toByteArray()) + "]"));
            }
            catch (IOException e) {
                _logger.error((Object)"Unexpected Exception while reading request resource", (Throwable)e);
            }
        }
        PostMethod postMethod = new PostMethod(endpointURL);
        InputStream requestStream = this.getTestKit().getResourceAsStream(requestResource);
        try {
            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(requestStream, this._contentType + "; charset=utf-8"));
            this.execute((HttpMethod)postMethod);
        }
        finally {
            try {
                requestStream.close();
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected exception closing HTTP request resource stream.");
            }
        }
        return postMethod;
    }

    public String postResource(String endpointURL, String requestResource) {
        String response = null;
        try {
            HttpMethod httpMethod = this.postResourceAndGetMethod(endpointURL, requestResource);
            response = httpMethod.getResponseBodyAsString();
            httpMethod.releaseConnection();
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response", (Throwable)ioe);
        }
        return response;
    }

    public String postResourceAndTestXML(String endpointURL, String requestResource, String expectedResponseResource) {
        String response = this.postResource(endpointURL, requestResource);
        this.getTestKit().compareXMLToResource(response, expectedResponseResource);
        return response;
    }

    public int postResourceAndGetStatus(String endpointURL, String requestResource) {
        HttpMethod httpMethod = this.postResourceAndGetMethod(endpointURL, requestResource);
        int status = httpMethod.getStatusCode();
        httpMethod.releaseConnection();
        return status;
    }

    public String execute(HttpMethod method) {
        if (this._httpClient == null) {
            Assert.fail((String)"HTTPMixIn not initialized.  You must call the initialize() method before using this MixIn");
        }
        for (String key : this._requestHeaders.keySet()) {
            method.setRequestHeader(key, this._requestHeaders.get(key));
        }
        if (this._dumpMessages) {
            for (Header header : method.getRequestHeaders()) {
                _logger.info((Object)("Request header:[" + header.getName() + "=" + header.getValue() + "]"));
            }
        }
        String response = null;
        try {
            this._httpClient.executeMethod(method);
            response = method.getResponseBodyAsString();
        }
        catch (Exception e) {
            try {
                Assert.fail((String)("Exception invoking HTTP endpoint '" + method.getURI() + "': " + e.getMessage()));
            }
            catch (URIException e1) {
                _logger.error((Object)"Unexpected error", (Throwable)e1);
                return null;
            }
        }
        if (this._dumpMessages) {
            for (Header header : method.getResponseHeaders()) {
                _logger.info((Object)("Received response header:[" + header.getName() + "=" + header.getValue() + "]"));
            }
            _logger.info((Object)("Received response body:[" + response + "]"));
        }
        for (String key : this._expectedHeaders.keySet()) {
            Header actual = method.getResponseHeader(key);
            Assert.assertNotNull((String)("Checking response header:[" + key + "]"), (Object)actual);
            Assert.assertEquals((String)("Checking response header:[" + key + "]"), (Object)this._expectedHeaders.get(key), (Object)actual.getValue());
        }
        return response;
    }

    public HTTPMixIn setRequestHeader(String name, String value) {
        this._requestHeaders.put(name, value);
        return this;
    }

    public HTTPMixIn setRequestHeaders(Map<String, String> headers) {
        this._requestHeaders.clear();
        this._requestHeaders.putAll(headers);
        return this;
    }

    public HTTPMixIn setExpectedHeader(String name, String value) {
        this._expectedHeaders.put(name, value);
        return this;
    }

    public HTTPMixIn setExpectedHeaders(Map<String, String> headers) {
        this._expectedHeaders.clear();
        this._expectedHeaders.putAll(headers);
        return this;
    }

    public HTTPMixIn setDumpMessages(boolean dumpMessages) {
        this._dumpMessages = dumpMessages;
        return this;
    }

    public void uninitialize() {
        if (this._httpClient != null) {
            HttpConnectionManager connectionManager = this._httpClient.getHttpConnectionManager();
            if (connectionManager instanceof MultiThreadedHttpConnectionManager) {
                MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = (MultiThreadedHttpConnectionManager)connectionManager;
                multiThreadedHttpConnectionManager.shutdown();
            }
            connectionManager.closeIdleConnections(0L);
        }
    }
}

