/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.jca;

import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.resource.cci.MessageListener;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.hornetq.core.version.Version;
import org.hornetq.utils.VersionLoader;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.switchyard.component.test.mixins.jca.MockActivationSpec;
import org.switchyard.component.test.mixins.jca.MockConnection;
import org.switchyard.component.test.mixins.jca.MockConnectionFactory;
import org.switchyard.component.test.mixins.jca.MockConnectionManager;
import org.switchyard.component.test.mixins.jca.MockManagedConnection;
import org.switchyard.component.test.mixins.jca.MockManagedConnectionFactory;
import org.switchyard.component.test.mixins.jca.MockResourceAdapter;
import org.switchyard.component.test.mixins.jca.ResourceAdapterConfig;
import org.switchyard.component.test.mixins.jca.ShrinkwrapUtil;
import org.switchyard.component.test.mixins.jca.SwitchYardIronJacamarHandler;
import org.switchyard.component.test.mixins.jca.TransactionManagerLocator;
import org.switchyard.component.test.mixins.naming.NamingMixIn;
import org.switchyard.component.test.mixins.transaction.TransactionMixInParticipant;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.mixins.AbstractTestMixIn;

@Deprecated
@MixInDependencies(required={NamingMixIn.class})
public class JCAMixIn
extends AbstractTestMixIn
implements TransactionMixInParticipant {
    private static final String JNDI_PREFIX = "java:jboss";
    private static final String JNDI_USER_TRANSACTION = "java:jboss/UserTransaction";
    private static final String HORNETQ_DEFAULT_CF_JNDI = "java:/JmsXA";
    private static final String HORNETQ_DEFAULT_MCF_CLASS = "org.hornetq.ra.HornetQRAManagedConnectionFactory";
    private static final String MOCK_DEFAULT_MCF_CLASS = "org.switchyard.test.mixins.jca.MockManagedConnectionFactory";
    private static final String MOCK_RESOURCE_ADAPTER_XML = "jcamixin-mock-ra.xml";
    private static final String HORNETQ_RESOURCE_ADAPTER_XML = "jcamixin-hornetq-ra.xml";
    private Logger _logger = Logger.getLogger(JCAMixIn.class);
    private SwitchYardIronJacamarHandler _ironJacamar;
    private ResourceAdapterRepository _resourceAdapterRepository;

    public void initialize() {
        super.initialize();
        try {
            this._ironJacamar = new SwitchYardIronJacamarHandler();
            this._ironJacamar.startup();
            this._resourceAdapterRepository = this._ironJacamar.getResourceAdapterRepository();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Failed to start IronJacamar Embedded: " + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(AbstractDeployment deployment) {
        for (Activator activator : this.getTestKit().getActivators()) {
            for (Field f : activator.getClass().getDeclaredFields()) {
                if (f.getType() != ResourceAdapterRepository.class) continue;
                f.setAccessible(true);
                try {
                    f.set(activator, this._resourceAdapterRepository);
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Failed to inject ResourceAdapterRepository into " + activator.getClass()), (Throwable)e);
                }
                finally {
                    f.setAccessible(false);
                }
            }
        }
    }

    public ResourceAdapter getResourceAdapter(String name) {
        try {
            String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(name));
            return this._resourceAdapterRepository.getResourceAdapter(raid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deployResourceAdapters(ResourceAdapterConfig ... adapters) {
        block4: for (ResourceAdapterConfig adapter : adapters) {
            switch (adapter.getType()) {
                case MOCK: {
                    this.deployMockResourceAdapter(adapter.getName(), adapter.getConnectionDefinitions());
                    continue block4;
                }
                case HORNETQ: {
                    this.deployHornetQResourceAdapter(adapter.getName(), adapter.getConnectionDefinitions());
                    continue block4;
                }
                default: {
                    this.deployResourceAdapter(adapter.getName(), adapter.getConnectionDefinitions());
                }
            }
        }
    }

    public void uninitialize() {
        block6: {
            block5: {
                try {
                    UserTransaction tx = this.getUserTransaction();
                    if (tx.getStatus() != 6) {
                        this._logger.warn((Object)("Invalid transaction status[" + tx.getStatus() + "] ...trying to rollback"));
                        tx.rollback();
                    }
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Failed to rollback transaction: " + e.getMessage()));
                    if (!this._logger.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
            try {
                this._ironJacamar.shutdown();
                this._ironJacamar = null;
            }
            catch (Throwable t) {
                this._logger.warn((Object)("An error has occured during shutting down IronJacamar embedded: " + t.getMessage()));
                if (!this._logger.isDebugEnabled()) break block6;
                t.printStackTrace();
            }
        }
        super.uninitialize();
    }

    public UserTransaction getUserTransaction() {
        try {
            InitialContext ic = new InitialContext();
            return (UserTransaction)ic.lookup(JNDI_USER_TRANSACTION);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JTAEnvironmentBean locateEnvironmentBean() throws Throwable {
        return this._ironJacamar.getEnvironmentBean();
    }

    private void deployMockResourceAdapter(String raName, Map<String, String> connDefs) {
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)(this.stripDotRarSuffix(raName == null ? "mock-ra.rar" : raName) + ".rar"));
        JavaArchive ja = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(UUID.randomUUID().toString() + ".jar"));
        ja.addClasses(new Class[]{MessageListener.class, MockActivationSpec.class, MockConnection.class, MockConnectionFactory.class, MockConnectionManager.class, MockManagedConnection.class, MockManagedConnectionFactory.class, MockResourceAdapter.class, TransactionManagerLocator.class});
        raa.addAsLibrary((Archive)ja);
        URL url = Thread.currentThread().getContextClassLoader().getResource(MOCK_RESOURCE_ADAPTER_XML);
        raa.setResourceAdapterXML(url);
        if (connDefs.size() == 0) {
            connDefs.put("java:jboss/" + this.stripDotRarSuffix(raName), MOCK_DEFAULT_MCF_CLASS);
        }
        this.deployResourceAdapterArchive(raa, connDefs);
    }

    private void deployHornetQResourceAdapter(String raName, Map<String, String> connDefs) {
        Version version = VersionLoader.getVersion();
        String hqVersion = version.getMajorVersion() + "." + version.getMinorVersion() + "." + version.getMicroVersion() + "." + version.getVersionSuffix();
        String nettyVersion = "3.6.2.Final-c0d783c";
        if (nettyVersion.indexOf(45) != -1) {
            nettyVersion = nettyVersion.substring(0, nettyVersion.indexOf(45));
        }
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)(this.stripDotRarSuffix(raName == null ? "hornetq-ra.rar" : raName) + ".rar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("io.netty", "netty", nettyVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-ra", hqVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-core-client", hqVersion, JavaArchive.class, "jar"));
        raa.addAsLibrary((Archive)ShrinkwrapUtil.getArchive("org.hornetq", "hornetq-jms-client", hqVersion, JavaArchive.class, "jar"));
        URL url = Thread.currentThread().getContextClassLoader().getResource(HORNETQ_RESOURCE_ADAPTER_XML);
        raa.setResourceAdapterXML(url);
        if (connDefs.size() == 0) {
            connDefs.put(HORNETQ_DEFAULT_CF_JNDI, HORNETQ_DEFAULT_MCF_CLASS);
        }
        this.deployResourceAdapterArchive(raa, connDefs);
    }

    private void deployResourceAdapter(String path, Map<String, String> connDefs) {
        URI uri = null;
        try {
            uri = Thread.currentThread().getContextClassLoader().getResource(path).toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File ra = new File(uri);
        ResourceAdapterArchive raa = (ResourceAdapterArchive)ShrinkWrap.createFromZipFile(ResourceAdapterArchive.class, (File)ra);
        this.deployResourceAdapterArchive(raa, connDefs);
    }

    private void deployResourceAdapterArchive(ResourceAdapterArchive raa, Map<String, String> connDefs) {
        try {
            this._ironJacamar.deploy(raa, connDefs);
            String raname = this.stripDotRarSuffix(raa.getName());
            String raid = this._ironJacamar.getResourceAdapterIdentifier(raname);
            ConnectorServices.registerResourceAdapter((String)raname);
            ConnectorServices.registerResourceAdapterIdentifier((String)raname, (String)raid);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

