/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.switchyard.deploy.osgi.NamespaceHandler;

@Command(scope="switchyard", name="namespace-list", description="List switchyard namespaces.")
public class NamespaceList
extends OsgiCommandSupport {
    protected Object doExecute() throws Exception {
        Collection refs = this.getBundleContext().getServiceReferences(NamespaceHandler.class, "(switchyard.namespaces=*)");
        if (refs != null) {
            TreeSet<URI> namespaces = new TreeSet<URI>();
            for (ServiceReference ref : refs) {
                namespaces.addAll(NamespaceList.getNamespaces(ref.getProperty("switchyard.namespaces")));
            }
            for (URI namespace : namespaces) {
                System.out.println(namespace.toString());
            }
        }
        return null;
    }

    private static List<URI> getNamespaces(Object ns) {
        if (ns == null) {
            throw new IllegalArgumentException("NamespaceHandler service does not have an associated switchyard.namespaces property defined");
        }
        if (ns instanceof URI[]) {
            return Arrays.asList((URI[])ns);
        }
        if (ns instanceof URI) {
            return Collections.singletonList((URI)ns);
        }
        if (ns instanceof String) {
            return Collections.singletonList(URI.create((String)ns));
        }
        if (ns instanceof String[]) {
            String[] strings = (String[])ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(strings.length);
            for (String string : strings) {
                namespaces.add(URI.create(string));
            }
            return namespaces;
        }
        if (ns instanceof Collection) {
            Collection col = (Collection)ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(col.size());
            for (Object o : col) {
                namespaces.add(NamespaceList.toURI(o));
            }
            return namespaces;
        }
        if (ns instanceof Object[]) {
            Object[] array = (Object[])ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(array.length);
            for (Object o : array) {
                namespaces.add(NamespaceList.toURI(o));
            }
            return namespaces;
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated switchyard.namespaces property defined which can not be converted to an array of URI");
    }

    private static URI toURI(Object o) {
        if (o instanceof URI) {
            return (URI)o;
        }
        if (o instanceof String) {
            return URI.create((String)o);
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated switchyard.namespaces property defined which can not be converted to an array of URI");
    }
}

