/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.helpdesk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kie.api.task.model.TaskSummary;
import org.switchyard.component.bpm.runtime.BPMTaskService;
import org.switchyard.component.bpm.runtime.BPMTaskServiceRegistry;
import org.switchyard.quickstarts.demos.helpdesk.HelpDeskUserGroupCallback;
import org.switchyard.quickstarts.demos.helpdesk.Ticket;

@ManagedBean(name="helpDesk")
@SessionScoped
public class HelpDesk {
    private static final Logger LOGGER = Logger.getLogger(HelpDesk.class);
    private static final String TICKET = "ticket";
    private static final String EN_UK = "en-UK";
    private final BPMTaskService _taskService = BPMTaskServiceRegistry.getTaskService(null, (QName)new QName("urn:switchyard-quickstart-demo:helpdesk:0.1.0", "HelpDeskService"));
    private final List<TaskSummary> _userTasks = Collections.synchronizedList(new ArrayList());
    private final Map<Long, Ticket> _userTickets = Collections.synchronizedMap(new LinkedHashMap());
    private String _userId = "krisv";

    public String getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public String getGroupId() {
        List groups = (List)HelpDeskUserGroupCallback.USERS_GROUPS.get(this._userId);
        return groups != null && groups.size() > 0 ? (String)groups.get(0) : null;
    }

    public Map<String, String> getUsersGroups() {
        LinkedHashMap<String, String> usersGroups = new LinkedHashMap<String, String>();
        for (Map.Entry entry : HelpDeskUserGroupCallback.USERS_GROUPS.entrySet()) {
            String key = (String)entry.getKey();
            usersGroups.put(key + " (" + (String)((List)entry.getValue()).get(0) + ")", key);
        }
        return usersGroups;
    }

    public List<TaskSummary> getUserTasks() {
        return this._userTasks;
    }

    public Map<Long, Ticket> getUserTickets() {
        return this._userTickets;
    }

    public void selectUser(ValueChangeEvent vce) {
        this.setUserId((String)vce.getNewValue());
        this.fetchTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTasks() {
        List list = this._userTasks;
        synchronized (list) {
            this._userTasks.clear();
            this._userTickets.clear();
            List tasks = this._taskService.getTasksAssignedAsPotentialOwner(this._userId, EN_UK);
            for (TaskSummary task : tasks) {
                this._userTasks.add(task);
                Map params = this._taskService.getTaskContent(task.getId().longValue());
                Ticket ticket = (Ticket)params.get(TICKET);
                this._userTickets.put(task.getProcessInstanceId(), ticket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTasks() {
        List list = this._userTasks;
        synchronized (list) {
            if (this._userTasks.size() > 0) {
                for (TaskSummary task : this._userTasks) {
                    this._taskService.claim(task.getId().longValue(), this._userId);
                    this._taskService.start(task.getId().longValue(), this._userId);
                    HashMap<String, Ticket> results = new HashMap<String, Ticket>();
                    Ticket ticket = (Ticket)this._userTickets.get(task.getProcessInstanceId());
                    results.put(TICKET, ticket);
                    this._taskService.complete(task.getId().longValue(), this._userId, results);
                }
            }
        }
    }

    public void submit() {
        try {
            this.completeTasks();
            this.fetchTasks();
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Problem processing tasks: ");
            sb.append(t.getClass().getName());
            String m = t.getMessage();
            if (m != null) {
                sb.append("(");
                sb.append(m);
                sb.append(")");
            }
            String msg = sb.toString();
            LOGGER.error((Object)msg, t);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(msg));
        }
    }
}

