/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.bean.service;

import javax.inject.Named;
import org.switchyard.annotations.Validator;
import org.switchyard.quickstarts.bean.service.Order;
import org.switchyard.quickstarts.bean.service.OrderAck;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;

@Named(value="Validators")
public class Validators {
    @Validator
    public ValidationResult validate(Order order) {
        System.out.println("|--- Validating Order object:[OrderID=" + order.getOrderId() + ", ItemID=" + order.getItemId() + ", quantity=" + order.getQuantity() + "] ---|");
        if (order.getQuantity() > 1000) {
            return BaseValidator.invalidResult((String)("Too many order quantity: " + order.getQuantity()));
        }
        return BaseValidator.validResult();
    }

    @Validator
    public ValidationResult validate(OrderAck orderAck) {
        System.out.println("|--- Validating OrderAck object:[OrderID=" + orderAck.getOrderId() + ", accepted=" + orderAck.isAccepted() + ", status=" + orderAck.getStatus() + "] ---|");
        return BaseValidator.validResult();
    }
}

