/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.bpel.xts.wsat.ws;

import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.UserTransaction;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.wst.Durable2PCParticipant;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.switchyard.quickstarts.bpel.xts.wsat.ws.OrderParticipant;

@Stateless
@WebService(name="AirportService", serviceName="AirportService", targetNamespace="http://www.jboss.org/bpel/examples/airport")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="/context-handlers.xml")
public class AirportService {
    private static Logger log = Logger.getLogger(AirportService.class.getName());

    @WebMethod
    @WebResult(name="fltid")
    public String getFLTID(@WebParam(name="from") String from, @WebParam(name="to") String to, @WebParam(name="date") Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return from + "/" + to + "/" + String.valueOf(c.get(2) + 1) + "/" + String.valueOf(c.get(5));
    }

    @WebMethod
    public void order(@WebParam(name="name") String name, @WebParam(name="fltid") String fltid) {
        log.info("AirportService:order");
        UserTransaction transactionId = UserTransactionFactory.userTransaction();
        if (transactionId != null) {
            log.info("Transaction ID = " + transactionId.toString());
            if (transactionId.toString().compareTo("Unknown") == 0) {
                log.info("JBoss AS is badly configured. (Enable XTS)");
                return;
            }
            OrderParticipant op = new OrderParticipant(transactionId.toString(), name, fltid);
            try {
                TransactionManagerFactory.transactionManager().enlistForDurableTwoPhase((Durable2PCParticipant)op, "org.switchyard.quickstarts.bpel.xts.wsat.ws:AirportService:" + name + ":" + fltid);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

