/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sap.binding.composer;

import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.composer.CamelMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightCustomerInfo;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.BookFlightRequest;

public class FlightCustomerInfoMessageComposer
extends CamelMessageComposer {
    private static final Logger LOG = LoggerFactory.getLogger(FlightCustomerInfoMessageComposer.class);

    public CamelBindingData decompose(Exchange exchange, CamelBindingData target) throws Exception {
        CamelBindingData response = super.decompose(exchange, target);
        BookFlightRequest bookFlightRequest = (BookFlightRequest)exchange.getMessage().getContent(BookFlightRequest.class);
        SAPEndpoint endpoint = (SAPEndpoint)target.getMessage().getExchange().getContext().getEndpoint("sap:destination:nplDest:BAPI_FLCUST_GETLIST", SAPEndpoint.class);
        Structure request = endpoint.getRequest();
        if (bookFlightRequest.getCustomerName() != null && bookFlightRequest.getCustomerName().length() > 0) {
            request.put((Object)"CUSTOMER_NAME", (Object)bookFlightRequest.getCustomerName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CUSTOMER_NAME = '{}' to request", (Object)bookFlightRequest.getCustomerName());
            }
        } else {
            throw new Exception("No Customer Name");
        }
        response.getMessage().setBody((Object)request);
        return response;
    }

    public Message compose(CamelBindingData source, Exchange exchange) throws Exception {
        String email;
        String phone;
        String region;
        String countryIso;
        String country;
        String city;
        String postalCode;
        String poBox;
        String street;
        String formOfAddress;
        String customerName;
        Structure flightCustomerGetListResponse;
        Message response = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(response));
        Set attachements = source.getMessage().getAttachmentNames();
        if (!attachements.isEmpty()) {
            for (Map.Entry entry : source.getMessage().getAttachments().entrySet()) {
                response.addAttachment((String)entry.getKey(), ((DataHandler)entry.getValue()).getDataSource());
            }
        }
        if ((flightCustomerGetListResponse = (Structure)source.getMessage().getBody(Structure.class)) == null) {
            throw new Exception("No Flight Customer Get List Response");
        }
        Table bapiReturn = (Table)flightCustomerGetListResponse.get((Object)"RETURN", Table.class);
        Structure bapiReturnEntry = (Structure)bapiReturn.get(0);
        if (!((String)bapiReturnEntry.get((Object)"TYPE", String.class)).equals("S")) {
            String message = (String)bapiReturnEntry.get((Object)"MESSAGE", String.class);
            throw new Exception("BAPI call failed: " + message);
        }
        Table customerList = (Table)flightCustomerGetListResponse.get((Object)"CUSTOMER_LIST", Table.class);
        if (customerList == null || customerList.size() == 0) {
            throw new Exception("No Customer Info.");
        }
        Structure customer = (Structure)customerList.get(0);
        FlightCustomerInfo flightCustomerInfo = new FlightCustomerInfo();
        String customerId = (String)customer.get((Object)"CUSTOMERID", String.class);
        if (customerId != null) {
            flightCustomerInfo.setCustomerNumber(customerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set customer number = '{}' in flight customer info", (Object)customerId);
            }
        }
        if ((customerName = (String)customer.get((Object)"CUSTNAME", String.class)) != null) {
            flightCustomerInfo.setName(customerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set customer name = '{}' in flight customer info", (Object)customerName);
            }
        }
        if ((formOfAddress = (String)customer.get((Object)"FORM", String.class)) != null) {
            flightCustomerInfo.setFormOfAddress(formOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set form of address = '{}' in flight customer info", (Object)formOfAddress);
            }
        }
        if ((street = (String)customer.get((Object)"STREET", String.class)) != null) {
            flightCustomerInfo.setStreet(street);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set street = '{}' in flight customer info", (Object)street);
            }
        }
        if ((poBox = (String)customer.get((Object)"POBOX", String.class)) != null) {
            flightCustomerInfo.setPoBox(poBox);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set PO box = '{}' in flight customer info", (Object)poBox);
            }
        }
        if ((postalCode = (String)customer.get((Object)"POSTCODE", String.class)) != null) {
            flightCustomerInfo.setPostalCode(postalCode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set postal code = '{}' in flight customer info", (Object)postalCode);
            }
        }
        if ((city = (String)customer.get((Object)"CITY", String.class)) != null) {
            flightCustomerInfo.setCity(city);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set city = '{}' in flight customer info", (Object)city);
            }
        }
        if ((country = (String)customer.get((Object)"COUNTR", String.class)) != null) {
            flightCustomerInfo.setCountry(country);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set country = '{}' in flight customer info", (Object)country);
            }
        }
        if ((countryIso = (String)customer.get((Object)"COUNTR_ISO", String.class)) != null) {
            flightCustomerInfo.setCountryIso(countryIso);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set iso country code = '{}' in flight customer info", (Object)countryIso);
            }
        }
        if ((region = (String)customer.get((Object)"REGION", String.class)) != null) {
            flightCustomerInfo.setRegion(region);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set region = '{}' in flight customer info", (Object)region);
            }
        }
        if ((phone = (String)customer.get((Object)"PHONE", String.class)) != null) {
            flightCustomerInfo.setPhone(phone);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set phone = '{}' in flight customer info", (Object)phone);
            }
        }
        if ((email = (String)customer.get((Object)"EMAIL", String.class)) != null) {
            flightCustomerInfo.setEmail(email);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set email = '{}' in flight customer info", (Object)email);
            }
        }
        response.setContent((Object)flightCustomerInfo);
        return response;
    }
}

