/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sap.binding.composer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.fusesource.camel.component.sap.SapSynchronousRfcDestinationEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.composer.CamelMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightConnectionInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightCustomerInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightHop;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightTripRequestInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.PassengerInfo;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.BookFlightResponse;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.ConnectionInfo;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.ConnectionInfoTable;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.FlightInfo;

public class CreateFlightTripMessageComposer
extends CamelMessageComposer {
    private static final Logger LOG = LoggerFactory.getLogger(CreateFlightTripMessageComposer.class);
    private static final String FLIGHT_TRIP_REQUEST_INFO = "flightTripRequestInfo";

    public CamelBindingData decompose(Exchange exchange, CamelBindingData target) throws Exception {
        Date passengerDateOfBirth;
        String passengerName;
        String flightConnectionClass;
        Date flightConnectionDepartureData;
        String flightConnectionNumber;
        String flightCustomerNumber;
        CamelBindingData response = super.decompose(exchange, target);
        FlightTripRequestInfo flightTripRequestInfo = (FlightTripRequestInfo)exchange.getMessage().getContent(FlightTripRequestInfo.class);
        FlightConnectionInfo flightConnectionInfo = flightTripRequestInfo.getFlightConnectionInfo();
        FlightCustomerInfo flightCustomerInfo = flightTripRequestInfo.getFlightCustomerInfo();
        PassengerInfo passengerInfo = flightTripRequestInfo.getPassengerInfo();
        exchange.getContext().setProperty(FLIGHT_TRIP_REQUEST_INFO, (Object)flightTripRequestInfo, Scope.EXCHANGE);
        SapSynchronousRfcDestinationEndpoint endpoint = (SapSynchronousRfcDestinationEndpoint)response.getMessage().getExchange().getContext().getEndpoint("sap-srfc-destination:nplDest:BAPI_FLTRIP_CREATE", SapSynchronousRfcDestinationEndpoint.class);
        Structure request = endpoint.createRequest();
        Structure flightTripData = (Structure)request.get((Object)"FLIGHT_TRIP_DATA", Structure.class);
        String travelAgencyNumber = flightConnectionInfo.getTravelAgencyNumber();
        if (travelAgencyNumber != null && travelAgencyNumber.length() != 0) {
            flightTripData.put((Object)"AGENCYNUM", (Object)travelAgencyNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added AGENCYNUM = '{}' to FLIGHT_TRIP_DATA", (Object)travelAgencyNumber);
            }
        }
        if ((flightCustomerNumber = flightCustomerInfo.getCustomerNumber()) != null && flightCustomerNumber.length() != 0) {
            flightTripData.put((Object)"CUSTOMERID", (Object)flightCustomerNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CUSTOMERID = '{}' to FLIGHT_TRIP_DATA", (Object)flightCustomerNumber);
            }
        }
        if ((flightConnectionNumber = flightConnectionInfo.getFlightConnectionNumber()) != null && flightConnectionNumber.length() != 0) {
            flightTripData.put((Object)"FLCONN1", (Object)flightConnectionNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added FLCONN1 = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionNumber);
            }
        }
        if ((flightConnectionDepartureData = flightConnectionInfo.getDepartureDate()) != null) {
            flightTripData.put((Object)"FLDATE1", (Object)flightConnectionDepartureData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added FLDATE1 = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionDepartureData);
            }
        }
        if ((flightConnectionClass = "Y") != null && flightConnectionClass.length() != 0) {
            flightTripData.put((Object)"CLASS", (Object)flightConnectionClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CLASS = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionClass);
            }
        }
        Table passengerList = (Table)request.get((Object)"PASSENGER_LIST", Table.class);
        Structure passengerListEntry = passengerList.add();
        String passengerFormOfAddress = passengerInfo.getFormOfAddress();
        if (passengerFormOfAddress != null && passengerFormOfAddress.length() != 0) {
            passengerListEntry.put((Object)"PASSFORM", (Object)passengerFormOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSFORM = '{}' to PASSENGER_LIST", (Object)passengerFormOfAddress);
            }
        }
        if ((passengerName = passengerInfo.getName()) != null && passengerName.length() != 0) {
            passengerListEntry.put((Object)"PASSNAME", (Object)passengerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSNAME = '{}' to PASSENGER_LIST", (Object)passengerName);
            }
        }
        if ((passengerDateOfBirth = passengerInfo.getDateOfBirth()) != null) {
            passengerListEntry.put((Object)"PASSBIRTH", (Object)passengerDateOfBirth);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSBIRTH = '{}' to PASSENGER_LIST", (Object)passengerDateOfBirth);
            }
        }
        response.getMessage().setBody((Object)request);
        return response;
    }

    public Message compose(CamelBindingData source, Exchange exchange) throws Exception {
        Message response = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(response));
        Set attachements = source.getMessage().getAttachmentNames();
        if (!attachements.isEmpty()) {
            for (Map.Entry entry : source.getMessage().getAttachments().entrySet()) {
                response.addAttachment((String)entry.getKey(), ((DataHandler)entry.getValue()).getDataSource());
            }
        }
        FlightTripRequestInfo flightTripRequestInfo = (FlightTripRequestInfo)exchange.getContext().getProperty(FLIGHT_TRIP_REQUEST_INFO).getValue();
        FlightConnectionInfo flightConnectionInfo = flightTripRequestInfo.getFlightConnectionInfo();
        PassengerInfo passengerInfo = flightTripRequestInfo.getPassengerInfo();
        Structure flightTripCreateResponse = (Structure)source.getMessage().getBody(Structure.class);
        if (flightTripCreateResponse == null) {
            throw new Exception("No Flight Trip Create Response");
        }
        Table bapiReturn = (Table)flightTripCreateResponse.get((Object)"RETURN", Table.class);
        Structure bapiReturnEntry = (Structure)bapiReturn.get(0);
        if (!((String)bapiReturnEntry.get((Object)"TYPE", String.class)).equals("S")) {
            String message = (String)bapiReturnEntry.get((Object)"MESSAGE", String.class);
            throw new Exception("BAPI call failed: " + message);
        }
        BookFlightResponse bookFlightResponse = new BookFlightResponse();
        String tripNumber = (String)flightTripCreateResponse.get((Object)"TRIPNUMBER", String.class);
        if (tripNumber != null) {
            bookFlightResponse.setTripNumber(tripNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TRIPNUMBER = '{}' to request", (Object)tripNumber);
            }
        } else {
            throw new Exception("No Flight Booking Trip Number");
        }
        Structure ticketPrice = (Structure)flightTripCreateResponse.get((Object)"TICKET_PRICE", Structure.class);
        if (ticketPrice != null) {
            BigDecimal tripPrice = (BigDecimal)ticketPrice.get((Object)"TRIPPRICE", BigDecimal.class);
            bookFlightResponse.setTicketPrice(tripPrice);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TICKET_PRICE = '{}' to request", (Object)tripPrice);
            }
            BigDecimal tripTax = (BigDecimal)ticketPrice.get((Object)"TRIPTAX", BigDecimal.class);
            bookFlightResponse.setTicketTax(tripTax);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TICKET_TAX = '{}' to request", (Object)tripTax);
            }
            String currency = (String)ticketPrice.get((Object)"CURR", String.class);
            bookFlightResponse.setCurrency(currency);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CURRENCY = '{}' to request", (Object)currency);
            }
        } else {
            throw new Exception("No Flight Booking Ticket Price");
        }
        bookFlightResponse.setPassengerFormOfAddress(passengerInfo.getFormOfAddress());
        bookFlightResponse.setPassengerName(passengerInfo.getName());
        bookFlightResponse.setPassengerDateOfBirth(passengerInfo.getDateOfBirth());
        FlightInfo flightInfo = new FlightInfo();
        flightInfo.setFlightTime(flightConnectionInfo.getFlightTime());
        flightInfo.setCityFrom(flightConnectionInfo.getDepartureCity());
        flightInfo.setDepartureDate(flightConnectionInfo.getDepartureDate());
        flightInfo.setDepartureTime(flightConnectionInfo.getDepartureTime());
        flightInfo.setCityTo(flightConnectionInfo.getArrivalCity());
        flightInfo.setArrivalDate(flightConnectionInfo.getArrivalDate());
        flightInfo.setArrivalTime(flightConnectionInfo.getArrivalTime());
        bookFlightResponse.setFlightInfo(flightInfo);
        ConnectionInfoTable connectionInfoTable = new ConnectionInfoTable();
        ArrayList<ConnectionInfo> rows = new ArrayList<ConnectionInfo>();
        for (FlightHop flightHop : flightConnectionInfo.getFlightHopList()) {
            ConnectionInfo connection = new ConnectionInfo();
            connection.setConnectionId(flightHop.getHopNumber());
            connection.setAirline(flightHop.getAirlineName());
            connection.setPlaneType(flightHop.getAircraftType());
            connection.setCityFrom(flightHop.getDepatureCity());
            connection.setDepartureDate(flightHop.getDepatureDate());
            connection.setDepartureTime(flightHop.getDepatureTime());
            connection.setCityTo(flightHop.getArrivalCity());
            connection.setArrivalDate(flightHop.getArrivalDate());
            connection.setArrivalTime(flightHop.getArrivalTime());
            rows.add(connection);
        }
        connectionInfoTable.setRows(rows);
        bookFlightResponse.setConnectionInfo(connectionInfoTable);
        response.setContent((Object)bookFlightResponse);
        return response;
    }
}

