/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.jms.binding;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQQueue;
import org.switchyard.quickstarts.camel.jms.binding.ClientUtil;

public final class HornetQClient {
    private static final String QUEUE_NAME = "GreetingServiceQueue";
    private static final String MESSAGE_PAYLOAD = "/test.txt";

    private HornetQClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] ignored) throws Exception {
        HornetQConnectionFactory hornetQConnectionFactory = null;
        Connection connection = null;
        Session session = null;
        try {
            hornetQConnectionFactory = new HornetQConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName())});
            connection = hornetQConnectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)new HornetQQueue(QUEUE_NAME));
            producer.send((Message)session.createTextMessage(ClientUtil.readFileContent(MESSAGE_PAYLOAD)));
            System.out.println("Message sent. Please see server console output");
        }
        catch (Throwable throwable) {
            ClientUtil.closeSession(session);
            ClientUtil.closeConnection(connection);
            ClientUtil.closeConnectionFactory(hornetQConnectionFactory);
            throw throwable;
        }
        ClientUtil.closeSession(session);
        ClientUtil.closeConnection(connection);
        ClientUtil.closeConnectionFactory(hornetQConnectionFactory);
    }
}

