/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.hornetq;

import org.hornetq.api.core.Message;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.switchyard.component.hornetq.ServerLocatorBuilder;
import org.switchyard.quickstarts.hornetq.ClientUtil;

public final class HornetQClient {
    private HornetQClient() {
    }

    public static void main(String[] ignored) throws Exception {
        ServerLocatorBuilder slb = new ServerLocatorBuilder();
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName());
        transportConfiguration.getParams().put("port", 5445);
        slb.transportConfigurations(new TransportConfiguration[]{transportConfiguration});
        slb.blockOnNonDurableSend(Boolean.valueOf(true));
        ServerLocator serverLocator = slb.build();
        ClientSessionFactory sessionFactory = serverLocator.createSessionFactory();
        ClientSession session = sessionFactory.createSession();
        session.start();
        ClientProducer producer = session.createProducer("jms.queue.GreetingServiceQueue");
        ClientMessage message = session.createMessage(false);
        message.getBodyBuffer().writeBytes(ClientUtil.readFileContent("/test.txt").getBytes());
        producer.send((Message)message);
        System.out.println("Sent message [" + message + "]");
        Thread.sleep(2000L);
        producer.close();
        session.close();
        sessionFactory.close();
    }
}

