/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.rest.binding;

import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyMessageComposer;
import org.switchyard.quickstarts.rest.binding.Item;
import org.switchyard.quickstarts.rest.binding.ItemNotFoundException;

public class CustomComposer
extends RESTEasyMessageComposer {
    public Message compose(RESTEasyBindingData source, Exchange exchange) throws Exception {
        Message message = super.compose(source, exchange);
        if (message.getContent() instanceof BaseClientResponse) {
            BaseClientResponse clientResponse = (BaseClientResponse)message.getContent();
            if (clientResponse.getResponseStatus() == Response.Status.NOT_FOUND) {
                throw new ItemNotFoundException("Item not found");
            }
        } else if (source.getOperationName().equals("addItem") && source.getParameters().length == 2) {
            Item item = new Item((Integer)source.getParameters()[0], (String)source.getParameters()[1]);
            message.setContent((Object)item);
        }
        return message;
    }

    public RESTEasyBindingData decompose(Exchange exchange, RESTEasyBindingData target) throws Exception {
        HandlerException he;
        Object content = exchange.getMessage().getContent();
        if (exchange.getState().equals((Object)ExchangeState.FAULT) && content instanceof HandlerException && (he = (HandlerException)content).getCause() instanceof ItemNotFoundException) {
            throw (Exception)he.getCause();
        }
        if ((target = super.decompose(exchange, target)).getOperationName().equals("addItem") && content != null && content instanceof Item) {
            target.setParameters(new Object[]{((Item)content).getItemId(), ((Item)content).getName()});
        }
        return target;
    }
}

