/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.addressing;

import javax.inject.Named;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.switchyard.quickstarts.soap.addressing.Order;
import org.switchyard.quickstarts.soap.addressing.UnknownItem;

@Named(value="orderProcessor")
public class OrderProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        String socketAddr = System.getProperty("org.switchyard.component.soap.standalone.port");
        String socketAddrFault = System.getProperty("org.switchyard.component.http.standalone.port");
        if (socketAddr == null) {
            socketAddr = "8080";
        }
        if (socketAddrFault == null) {
            socketAddrFault = "8080";
        }
        Order order = (Order)exchange.getIn().getBody(Order.class);
        System.out.println("Received Order " + order.getItem() + " with quantity " + order.getQuantity() + ".");
        if (order.getItem().equals("Airbus")) {
            throw new UnknownItem("Sorry, Airbus is no longer available with us!");
        }
        SOAPHeaderElement messageId = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}MessageID");
        if (messageId == null) {
            messageId = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}messageid");
        }
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}ReplyTo", "http://localhost:" + socketAddr + "/soap-addressing/client/ResponseService");
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}RelatesTo", messageId.getValue());
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}FaultTo", "http://localhost:" + socketAddrFault + "/soap-addressing/fault/FaultService");
        exchange.getOut().setBody((Object)order);
    }
}

