/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.binding.rpc;

import java.io.StringReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.annotations.Transformer;
import org.switchyard.quickstarts.soap.binding.rpc.SayHello;
import org.switchyard.quickstarts.soap.binding.rpc.SayHelloExternal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceTransformers {
    private static String SOAP_RESPONSE_TEMPLATE = "<ns2:sayHelloResponse xmlns:ns2=\"urn:switchyard-quickstart:soap-binding-rpc:1.0\">    <return>%s</return></ns2:sayHelloResponse>";
    private static String SOAP_TEMPLATE_EXTERNAL = "<ns2:sayHello xmlns:ns2=\"urn:switchyard-quickstart:external:1.0\">    <toWhom>%s</toWhom>    <language>%s</language>    <day>%s</day></ns2:sayHello>";
    private static String SOAP_RESPONSE_TEMPLATE_EXTERNAL = "<ns2:sayHelloResponse xmlns:ns2=\"urn:switchyard-quickstart:external:1.0\">    <return>%s</return></ns2:sayHelloResponse>";

    @Transformer(to="{urn:switchyard-quickstart:external:1.0}sayHello")
    public Element transformExternal(SayHello wrapper) throws Exception {
        return this.toElement(String.format(SOAP_TEMPLATE_EXTERNAL, wrapper.getToWhom(), wrapper.getLanguage(), "Sunday"));
    }

    @Transformer(from="{urn:switchyard-quickstart:soap-binding-rpc:1.0}sayHello")
    public SayHello transform(Element soap) throws Exception {
        SayHello wrapper = new SayHello();
        wrapper.setToWhom(this.getElementValue(soap, "toWhom"));
        wrapper.setLanguage(this.getElementValue(soap, "language"));
        return wrapper;
    }

    @Transformer(from="{urn:switchyard-quickstart:external:1.0}sayHello")
    public SayHelloExternal transformExternalRequest(Element soap) throws Exception {
        SayHelloExternal wrapper = new SayHelloExternal();
        wrapper.setToWhom(this.getElementValue(soap, "toWhom"));
        wrapper.setLanguage(this.getElementValue(soap, "language"));
        wrapper.setDay(this.getElementValue(soap, "day"));
        return wrapper;
    }

    @Transformer(to="{urn:switchyard-quickstart:soap-binding-rpc:1.0}sayHelloResponse")
    public Element transformInternalResponse(String response) throws Exception {
        return this.toElement(String.format(SOAP_RESPONSE_TEMPLATE, response));
    }

    @Transformer(to="{urn:switchyard-quickstart:external:1.0}sayHelloResponse")
    public Element transformExternalResponse(String response) throws Exception {
        return this.toElement(String.format(SOAP_RESPONSE_TEMPLATE_EXTERNAL, response));
    }

    @Transformer(from="{urn:switchyard-quickstart:external:1.0}sayHelloResponse")
    public String transformExternalResponse(Element soap) throws Exception {
        return this.getElementValue(soap, "return");
    }

    private String getElementValue(Element parent, String elementName) {
        String value = null;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            value = nodes.item(0).getChildNodes().item(0).getNodeValue();
        }
        return value;
    }

    private Element toElement(String xml) {
        DOMResult dom = new DOMResult();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(xml)), dom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Document)dom.getNode()).getDocumentElement();
    }
}

