/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.hornetq;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.MessageHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerChain;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.bus.hornetq.DispatchQueue;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.SerializerType;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.spi.Dispatcher;
import org.switchyard.transform.TransformerRegistry;

public class HornetQDispatcher
implements Dispatcher,
MessageHandler {
    private static final Serializer SERIALIZER = SerializerType.DEFAULT.instance();
    private ServiceReference _service;
    private DispatchQueue _inQueue;
    private DispatchQueue _outQueue;
    private ClientSessionFactory _sessionFactory;
    private HandlerChain _inputHandler;
    private Map<String, HandlerChain> _outputHandlers = new ConcurrentHashMap<String, HandlerChain>();
    private TransformerRegistry _transformerRegistry;

    public HornetQDispatcher(ServiceReference service, ClientSessionFactory sessionFactory, HandlerChain inputHandler, TransformerRegistry transformerRegistry) {
        this._service = service;
        this._sessionFactory = sessionFactory;
        this._inputHandler = inputHandler;
        this._transformerRegistry = transformerRegistry;
    }

    public ServiceReference getService() {
        return this._service;
    }

    public void dispatch(Exchange exchange) {
        DispatchQueue dispatch = null;
        if (exchange.getPhase().equals((Object)ExchangePhase.IN)) {
            dispatch = this._inQueue;
            if (ExchangePattern.IN_OUT.equals((Object)exchange.getContract().getServiceOperation().getExchangePattern())) {
                String messageId = (String)exchange.getContext().getProperty("org.switchyard.messageId", Scope.IN).getValue();
                this._outputHandlers.put(messageId, ((ExchangeImpl)exchange).getReplyChain());
            }
        } else if (exchange.getPhase().equals((Object)ExchangePhase.OUT)) {
            dispatch = this._outQueue;
        } else {
            throw new IllegalArgumentException("Invalid exchange phase for dispatch: " + exchange.getPhase());
        }
        try {
            Message msg = HornetQDispatcher.exchangeToMessage(exchange, dispatch.getSession());
            dispatch.getProducer().send(msg);
        }
        catch (HornetQException hqEx) {
            throw new SwitchYardException("Send to HornetQ endpoint failed", (Throwable)hqEx);
        }
    }

    public void onMessage(ClientMessage message) {
        String relatesTo;
        HandlerChain chain;
        Exchange exchange = this.messageToExchange((Message)message);
        if (ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            this._inputHandler.handle(exchange);
        } else if (ExchangePhase.OUT.equals((Object)exchange.getPhase()) && (chain = this._outputHandlers.remove(relatesTo = (String)exchange.getContext().getProperty("org.switchyard.relatesTo", Scope.OUT).getValue())) != null) {
            chain.handle(exchange);
        }
    }

    public void stop() {
        try {
            if (this._inQueue != null) {
                this._inQueue.destroy();
            }
            if (this._outQueue != null) {
                this._outQueue.destroy();
            }
        }
        catch (HornetQException ex) {
            throw new SwitchYardException("Failed to stop HornetQ endpoint " + this._service.getName(), (Throwable)ex);
        }
    }

    public void start() {
        try {
            this._inQueue = new DispatchQueue(this._sessionFactory.createSession(), this._service.getName().toString() + ExchangePhase.IN, this);
            this._inQueue.init();
            for (ServiceOperation op : this._service.getInterface().getOperations()) {
                if (!op.getExchangePattern().equals((Object)ExchangePattern.IN_OUT)) continue;
                this._outQueue = new DispatchQueue(this._sessionFactory.createSession(), this._service.getName().toString() + ExchangePhase.OUT, this);
                this._outQueue.init();
                break;
            }
        }
        catch (HornetQException ex) {
            throw new SwitchYardException("Failed to start HornetQ endpoint " + this._service.getName(), (Throwable)ex);
        }
    }

    private Exchange messageToExchange(Message message) {
        ExchangeImpl exchange;
        HornetQBuffer buffer = message.getBodyBuffer();
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        try {
            exchange = (ExchangeImpl)SERIALIZER.deserialize(bytes, ExchangeImpl.class);
            new FieldAccess(ExchangeImpl.class.getDeclaredField("_dispatch")).write((Object)exchange, (Object)this);
            new FieldAccess(ExchangeImpl.class.getDeclaredField("_transformerRegistry")).write((Object)exchange, (Object)this._transformerRegistry);
            new FieldAccess(DefaultMessage.class.getDeclaredField("_transformerRegistry")).write((Object)exchange.getMessage(), (Object)this._transformerRegistry);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
        catch (NoSuchFieldException nsfe) {
            throw new SwitchYardException((Throwable)nsfe);
        }
        return exchange;
    }

    private static Message exchangeToMessage(Exchange exchange, ClientSession session) {
        byte[] bytes;
        try {
            bytes = SERIALIZER.serialize((Object)((ExchangeImpl)exchange), ExchangeImpl.class);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
        ClientMessage msg = session.createMessage(false);
        msg.getBodyBuffer().writeBytes(bytes);
        return msg;
    }
}

