/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseMarshaller;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;
import org.switchyard.config.model.composite.v1.V1ComponentImplementationModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceInterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1CompositeReferenceModel;
import org.switchyard.config.model.composite.v1.V1CompositeServiceModel;

public class V1CompositeMarshaller
extends BaseMarshaller {
    public V1CompositeMarshaller(Descriptor desc) {
        super(desc);
    }

    @Override
    public Model read(Configuration config) {
        String name = config.getName();
        Descriptor desc = this.getDescriptor();
        if (name.equals("composite")) {
            return new V1CompositeModel(config, desc);
        }
        if (name.equals("service")) {
            Configuration config_parent = config.getParent();
            if (config_parent != null) {
                if (config_parent.getName().equals("composite")) {
                    return new V1CompositeServiceModel(config, desc);
                }
                if (config_parent.getName().equals("component")) {
                    return new V1ComponentServiceModel(config, desc);
                }
            }
        } else {
            Configuration config_parent;
            if (name.startsWith("binding")) {
                return new V1BindingModel(config, desc);
            }
            if (name.equals("component")) {
                return new V1ComponentModel(config, desc);
            }
            if (name.startsWith("implementation")) {
                return new V1ComponentImplementationModel(config, desc);
            }
            if (name.startsWith("interface")) {
                Configuration config_parent2 = config.getParent();
                if (config_parent2 != null) {
                    if (config_parent2.getName().equals("service")) {
                        return new V1ComponentServiceInterfaceModel(config, desc);
                    }
                    if (config_parent2.getName().equals("reference")) {
                        return new V1ComponentReferenceInterfaceModel(config, desc);
                    }
                }
            } else if (name.equals("reference") && (config_parent = config.getParent()) != null) {
                if (config_parent.getName().equals("composite")) {
                    return new V1CompositeReferenceModel(config, desc);
                }
                if (config_parent.getName().equals("component")) {
                    return new V1ComponentReferenceModel(config, desc);
                }
            }
        }
        return null;
    }
}

