/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deployment;

import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.switchyard.ServiceDomain;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.Deployment;

public class SwitchYardDeployment
extends Deployment {
    private final VFSDeploymentUnit _deployUnit;
    private ServiceDomainManager _domainManager;

    public SwitchYardDeployment(String deploymentName, VFSDeploymentUnit deploymentUnit, SwitchYardModel config, ServiceDomainManager domainManager) {
        super(config);
        this._deployUnit = deploymentUnit;
        this._domainManager = domainManager;
    }

    public void create() {
    }

    public void destroy() {
        this._domainManager.removeApplicationServiceDomain(this.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._deployUnit.getClassLoader());
            super.init(SwitchYardDeployment.createDomain(this.getConfig(), this._domainManager));
            super.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._deployUnit.getClassLoader());
            super.stop();
            super.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private static ServiceDomain createDomain(SwitchYardModel config, ServiceDomainManager domainManager) {
        return domainManager.addApplicationServiceDomain(ServiceDomainManager.ROOT_DOMAIN, config);
    }
}

