/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deployment;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.vfs.VirtualFile;
import org.switchyard.deployment.SwitchYardMetaData;

public class SwitchYardConfigParser
extends AbstractVFSParsingDeployer<SwitchYardMetaData> {
    private static final String META_INF_DIR = "META_INF";
    private static final String SWITCHYARD_XML_FILE = "switchyard.xml";
    private static final String SWITCHYARD_DEPLOYMENT_XML = "META_INF/switchyard.xml";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private Logger _log = Logger.getLogger(SwitchYardConfigParser.class);

    public SwitchYardConfigParser() {
        super(SwitchYardMetaData.class);
        this.setSuffix(SWITCHYARD_XML_FILE);
        this.setJarExtension(JAR_FILE_EXTENSION);
        this.setStage(DeploymentStages.PARSE);
    }

    protected SwitchYardMetaData parse(VFSDeploymentUnit deploymentUnit, VirtualFile file, SwitchYardMetaData metadata) throws Exception {
        VirtualFile configFile = this.findSwitchYardConfigFile(file);
        String archiveName = deploymentUnit.getSimpleName();
        String deploymentName = this.getDeploymentName(deploymentUnit);
        if (!configFile.isFile()) {
            throw new DeploymentException("Could not find META_INF/switchyard.xml");
        }
        SwitchYardMetaData switchYardMetaData = new SwitchYardMetaData(archiveName, deploymentName);
        this._log.debug((Object)("Located configuration for deployment unit '" + deploymentUnit.getName() + "' and attached to deployment metadata instance."));
        switchYardMetaData.setSwitchYardFile(configFile);
        return switchYardMetaData;
    }

    private VirtualFile findSwitchYardConfigFile(VirtualFile file) throws DeploymentException, IOException {
        if (file.getName().endsWith(SWITCHYARD_XML_FILE)) {
            return file;
        }
        VirtualFile child = file.getChild(META_INF_DIR);
        VirtualFile xml = child.getChild(SWITCHYARD_DEPLOYMENT_XML);
        return xml;
    }

    String getDeploymentName(VFSDeploymentUnit deploymentUnit) {
        String simpleName = deploymentUnit.getSimpleName();
        int idx = simpleName.indexOf(JAR_FILE_EXTENSION);
        if (idx == -1) {
            return simpleName;
        }
        return simpleName.substring(0, simpleName.indexOf(JAR_FILE_EXTENSION));
    }
}

