/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Component;
import org.switchyard.admin.ComponentType;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemListComponents
implements OperationStepHandler {
    public static final SwitchYardSubsystemListComponents INSTANCE = new SwitchYardSubsystemListComponents();

    private SwitchYardSubsystemListComponents() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode components = context.getResult();
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                EnumSet<ComponentType> desiredComponentTypes = operation.hasDefined("type") && !"all".equalsIgnoreCase(operation.get("type").asString()) ? EnumSet.of(ComponentType.valueOf((String)operation.get("type").asString().toUpperCase())) : EnumSet.allOf(ComponentType.class);
                for (Component component : switchYard.getComponents()) {
                    if (!desiredComponentTypes.contains(component.getType())) continue;
                    components.add(component.getName());
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

